'\"
'\" Copyright 1993-1994 by AT&T Bell Laboratories.
'\" 
'\" Permission to use, copy, modify, and distribute this software
'\" and its documentation for any purpose and without fee is hereby
'\" granted, provided that the above copyright notice appear in all
'\" copies and that both that the copyright notice and warranty
'\" disclaimer appear in supporting documentation, and that the
'\" names of AT&T Bell Laboratories any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the
'\" software without specific, written prior permission.
'\"
'\" AT&T disclaims all warranties with regard to this software, including
'\" all implied warranties of merchantability and fitness.  In no event
'\" shall AT&T be liable for any special, indirect or consequential
'\" damages or any damages whatsoever resulting from loss of use, data
'\" or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or
'\" performance of this software.
'\"
'\" Window command created by George Howlett.
'\"
.so man.macros
.HS winop BLT
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
winop \- Perform assorted window operations
.SH SYNOPSIS
\fBwinop lower\fR ?\fIwindow\fR?...
.sp
\fBwinop map\fR ?\fIwindow\fR?...
.sp
\fBwinop raise\fR ?\fIwindow\fR?...
.sp
\fBwinop unmap\fR ?\fIwindow\fR?...
.sp
\fBwinop warpto\fR ?\fIwindow\fR?
.BE
.SH DESCRIPTION
The \fBwinop\fR command performs assorted window operations on Tk
windows using Xlib functions.  
.SH INTRODUCTION
Tk has several commands for manipulating its windows: \fBraise\fR,
\fBlower\fR, \fBwm\fR, etc.  Sometimes, interactions with particular
window managers prevent the normal operation of these commands.
.PP
In situations like these, the \fBwinop\fR command can be used to
workaround these difficulties.  Instead, it makes low-level Xlib
(such \fBXRaiseWindow\fR and \fBXMapWindow\fR) calls to perform these
operations.
.SH OPERATIONS
The following operations are available for the \fBwinop\fR command:
.TP
\fBwinop lower\fR ?\fIwindow\fR?...
Lowers \fIwindow\fR to the bottom of the X window stack.  \fIWindow\fR is
the path name of a Tk window.  
.TP
\fBwinop map\fR ?\fIwindow\fR?...
Maps \fIwindow\fR on the screen.  \fIWindow\fR
is the path name of a Tk window. If \fIwindow\fR is already mapped,
this command has no effect.  
.TP
\fBwinop raise\fR ?\fIwindow\fR?...
Raises \fIwindow\fR to the top of the X window stack. \fIWindow\fR must be
a valid path name of a Tk window.  This command returns the empty string.
.TP
\fBwinop unmap\fR ?\fIwindow\fR?...
Unmaps \fIwindow\fR from the screen. \fIWindow\fR is the path name of a Tk
window. 
.TP
\fBwinop warpto\fR ?\fIwindow\fR?
Warps the pointer to \fIwindow\fR. \fIWindow\fR is the path name of a Tk window
which must be mapped. If \fIwindow\fR is in the form \fI@x,y\fR, where
\fIx\fR and \fIy\fR are root screen coordinates, the pointer is warped to
that location on the screen.
.sp
[\fII've never heard a good case for warping the pointer in an
application.  It can be useful for testing, but in applications, it's
always a bad idea.  Simply stated, the user owns the pointer, not the
application.  If you have an application that needs it, I'd like to
hear about it.\fR]
.sp
If no \fIwindow\fR argument is present the current location of the
pointer is returned. The location is returned as a list in the form
"\fIx y\fR", where \fIx\fR and \fIy\fR are the current coordinates of
the pointer.
.SH KEYWORDS
window, map, raise, lower, pointer, warp
