/*                  AFDISK  -  Amiga RDB Fdisk for Linux
 *              fdisk.c part  -  generic input output stuff
 *                   written in 1996 by Stefan Reinauer
 *
 *    Copyright (C) 1996, 1997 Stefan Reinauer
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 1, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
 */

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>

#include "amiga/types.h"
#include "amigastuff.h"

#define VERSION "0.03"
#define RELDATE "97/03/31"

char *testdevs[] = { "/dev/hda",
                     "/dev/hdb",
                  /* "/dev/hdc",
                     "/dev/hdd", */
                     "/dev/sda",
                     "/dev/sdb",
                     "/dev/sdc",
                     "/dev/sdd",
                     "/dev/sde",
                     "/dev/sdf",
                     "/dev/sdg",
                     "/dev/sdh",
                     NULL };


char *entry;
int  list_only=0, get_dev=0;

int partition(void)
{
  partition_show();
  fprintf (stdout,"Partition number : ");
  gets(entry);
  return atonum(entry);
}

int listknown(void)
{
     fprintf(stdout,"Known Partition Types
---------------------

 1.  DOS\\0     Old Filesystem
 2.  DOS\\1     Original FastFileSystem (FFS)
 3.  DOS\\2     Old International Filesystem
 4.  DOS\\3     International FastFileSystem
 5.  DOS\\4     Old Filesystem with directory cache
 6.  DOS\\6     FastFileSystem with directory cache
 7.  UNI\\0     classic AT&T System-V filesystem
 8.  UNI\\1     UNIX boot \"filesystem\" (dummy entry for Amiga OS's boot menu)
 9.  UNI\\2     Berkeley filesystem for System V
10.  RESV       Reserved (e.g. swap space)
11.  LNX\\0	Linux native
12.  SWP\\0	Linux swap

");
 return 0;
}
ULONG gettype(void)
{
  listknown();
  fprintf (stdout,"
  Choose a number of the upper list or
  a DosType of the format 0x444f5302

Enter DosType: ");
  gets(entry);
  switch (atonum(entry)) {
    case 0:
      return (ULONG)(*entry);
    case 1:      return 0x444f5300;
    case 2:      return 0x444f5301;
    case 3:      return 0x444f5302;
    case 4:      return 0x444f5303;
    case 5:      return 0x444f5304;
    case 6:      return 0x444f5305;
    case 7:      return 0x554e4900;
    case 8:      return 0x554e4901;
    case 9:      return 0x554e4902;
    case 10:     return 0x52455356;
    case 11:     return 0x4C4E5800;
    case 12:     return 0x53575000;
    default:     return (atonum(entry));
  }
  return 0;
}

 
int main(int argc, char **argv)
{
 int dummy=0, c, tdcount=0;
 extern char *optarg;

 entry=malloc(256);

 while(((c = getopt(argc, argv, "-dvls:TViN:A:u:xC:H:S:fqLnRO:I:?")) != EOF)) switch(c) {
   case 1:   get_dev=1;
             strcpy(disk_device, optarg);
             break;
   case 'v': printf ("afdisk %s (%s) RDB by Stefan Reinauer, <stepan@matrix.kommune.schokola.de>\n",VERSION,RELDATE); exit (0);
   case '?': printf ("\nUsage: %s [-l] [-v] [-d] [-s /dev/hdxn] [/dev/hdx]\n",argv[0]);
             exit(0);

   case 'l':
     list_only = 1;
     break;
   case 's': printf ("List Size of the partition - not yet implemented\n"); exit(0);
   case 'd': printf ("Dump Partition table in afdisk-format - not yet implemented\n");
             exit(0);

   case 'T': printf ("Print recognized Partition types - not yet implemented\n");
             exit(0);
   case 'V': printf ("Verify partitions - not yet implemented\n");
             exit(0);
   case 'i': printf ("Start with Cylinder 1 - not yet implemented\n");
             exit(0);
   case 'N': printf ("Change only single partition - not yet implemented\n");
             exit(0);
   case 'A': printf ("make partition active - not yet implemented\n");
             exit(0);
   case 'c': printf ("change partition id - not yet implemented\n");
             exit(0);
   case 'u': printf ("Unit Size - not yet implemented\n");
             exit(0);
   case 'x': printf ("show extended  - not yet implemented\n");
             exit(0);
   case 'C': printf ("Specify Cylinders - override kernel - not yet implemented\n");
             exit(0);
   case 'H': printf ("Specify Heads- override kernel - not yet implemented\n");
             exit(0);
   case 'S': printf ("Specify Sectors- override kernel - not yet implemented\n");
             exit(0);
   case 'f': printf ("force - even if stupid - not yet implemented\n");
             exit(0);
   case 'q': printf ("quiet execution - not yet implemented\n");
             exit(0);
   case 'L': printf ("Not complain about Linux irrelevant things - not yet implemented\n");
             exit(0);
   case 'n': printf ("Do not write to disk - not yet implemented\n");
             exit(0);
   case 'R': printf ("BLKRRPART only - not yet implemented\n");
             exit(0);
   case 'O': printf ("Save Sector Table to file - not yet implemented\n");
             exit(0);
   case 'I': printf ("Restore SecTable from file - not yet implemented\n");
             exit(0);

}

 if (list_only) {
     if (get_dev) {
       if (get_rdb()!=-1) {
         rigiddisk_show();
         partition_show();
         printf ("\n");
       }
       exit(0);
     } else {
       while (testdevs[tdcount] != NULL) {
         strcpy(disk_device, testdevs[tdcount]);

         if (get_rdb()!=-1) {
           rigiddisk_show();
           partition_show();
           printf ("\n");
         }
         tdcount++;
       }
       exit(0);
     }
 } else {
     if (!get_dev) fprintf (stdout, "Using %s as default device!\n",disk_device);
     if (get_rdb()==-1) return -1;
 }

 printf ("\n");  
 for (;;) {
  /* pt(); */
  fprintf (stdout,"Command (m for help): ");
  gets(entry);
  switch ((*entry)) {
   case 'q':
   case 'Q':
     quitall(); free(entry);
     exit(0);
   case 'l':
   case 'L':
     listknown(); break;
   case 'p':
   case 'P':
     printf ("\n");
     rigiddisk_show();
     partition_show();
     printf ("\n");
     break;
   case 'a':
   case 'A':
     partition_togglebootable(partition());
     break;
   case 'b':
   case 'B':
     dummy=partition();
     fprintf (stdout,"Number of bootblocks : ");
     gets(entry);
     partition_bootblk(dummy,atonum(entry));
     break;
   case 'c':
   case 'C':
     dummy=partition();
     fprintf (stdout,"New Boot Priority : ");
     gets(entry);
     partition_bootpri(dummy,atonum(entry));
     break;
   case 'd':
   case 'D':
     partition_delete(partition());
     break;
   case 'e':
   case 'E':
     partition_togglenomount(partition());
     break;
   case 'n':
   case 'N':
     if (room_for_partition()!=-1) {
      dummy=partition();
      if (partition_new(dummy)!=-1) {
        fprintf (stdout,"Low Cylinder : ");
        gets(entry);
        partition_locyl(dummy,atonum(entry));
 
        fprintf (stdout,"High Cylinder : ");
        gets(entry);
        partition_hicyl(dummy,atonum(entry));
      }
     }
     break;
   case 't':
   case 'T':
     dummy=partition();
     partition_dostype(dummy,gettype());
     break;
   case 'w':
   case 'W':
     rigiddisk_reorg(firstblock);
     rigiddisk_save();
     fprintf (stdout,"You MUST reboot now to renew partition table\n");
     exit(0);
   case 'r':
   case 'R':
     printf ("\n");
     rigiddisk_show();
     fprintf(stdout,"\n RDB start at: ");
     gets(entry);
     rigiddisk_reorg(atonum(entry));
     break;
   case 'm':
   case 'M':
   default:
  
    printf ("Command action
   a   toggle bootable flag
   b   change number of bootblocks
   c   change boot priority
   d   delete a partition
   e   toggle nomount flag
   l   list known partition types
   m   print this menu
   n   add a new partition
   p   print the partition table
   q   quit without saving changes
   t   change a partition's DosType
   r   reorganize/move RDB
   w   write table to disk and exit

"); break;
  }
 }
}
