#include "swserv.h"
  
 
 
int NetHandleObjectPose(int condescriptor, char *arg)
{
        static long object_num;
        
        static int type;
        static int isref_num;
        static long size;
        
        static double x, y, z;
        static double heading, pitch, bank;
        
        static double velocity;
        
        static double velocity_heading;
        static double velocity_pitch;
        static double velocity_bank;

        static int current_frame;
        static xsw_object_struct *obj_ptr;


        /*
         *	CS_CODE_POSEOBJ format:
         *
         *      object_num,
         *      type, isref_num, size,
         *      x, y, z,
         *      heading, pitch,
         *      velocity, velocity_heading,
         *      throttle, frame
         */
        sscanf(arg,
"%ld\
 %i %i %ld\
 %lf %lf %lf\
 %lf %lf %lf\
 %lf\
 %lf %lf %lf\
 %i",
 
                &object_num,
            
                &type,
                &isref_num,
                &size,
        
                &x, 
                &y,
                &z,
        
                &heading,
                &pitch,
                &bank,
        
                &velocity,
         
                &velocity_heading,
                &velocity_pitch,
                &velocity_bank,
         
                &current_frame 
        );

	/* Connection must own object. */         
        if(connection[condescriptor]->object_num != object_num)
            return(-3);
 

	if(DBIsObjectGarbage(object_num))
	    return(-1);
	else
	    obj_ptr = xsw_object[object_num];


        /* Set object_num's location and apperance. */
        /* Don't set type, imageset, or size. */
/*
        obj_ptr->type = type;
        obj_ptr->imageset = isref_num;
        obj_ptr->size = size;
*/


        /* Set these only if object has enough antimatter. */
        if(obj_ptr->antimatter > 0)
        {
            obj_ptr->x = x;
            obj_ptr->y = y;
            obj_ptr->z = z;
            obj_ptr->velocity = velocity;
            obj_ptr->velocity_heading = velocity_heading;
        }

        obj_ptr->heading = heading;
        obj_ptr->pitch = pitch;

/*
        obj_ptr->animation.current_frame = current_frame;
*/

        return(0);
}


int NetSendObjectPose(int condescriptor, long object_num)
{
        static char sndbuf[CS_DATA_MAX_LEN];
        static xsw_object_struct *obj_ptr;  


        if(DBIsObjectGarbage(object_num))
            return(-1);
        else
            obj_ptr = xsw_object[object_num];


        /*
         *	CS_CODE_POSEOBJ format:
         *
         *      object_num,
         *      type, isref_num, size,
         *      x, y, z,
         *      heading, pitch, bank,
         *      velocity,
         *      velocity_heading, velocity_pitch, velocity_bank,
         *      current_frame
         */
        sprintf(sndbuf,
"%i %ld\
 %i %i %ld\
 %.4lf %.4lf %.4lf\
 %.4lf %.4lf %.4lf\
 %.4lf\
 %.4lf %.4lf %.4lf\
 %i\n",
   
                CS_CODE_POSEOBJ,
                object_num,
        
                obj_ptr->type,
                obj_ptr->imageset,
                obj_ptr->size,

                obj_ptr->x,
                obj_ptr->y,
                obj_ptr->z,

                obj_ptr->heading,
                obj_ptr->pitch,
                obj_ptr->bank,
         
                obj_ptr->velocity,

                obj_ptr->velocity_heading,
                0.0000, 
                0.0000,

                obj_ptr->animation.current_frame
        );


        /* Send data to all or single connection. */
        NetDoSend(condescriptor, sndbuf);


        return(0); 
}
