#ifndef UNVFILE_H
#define UNVFILE_H

#include <stdio.h>
#include "objects.h"


extern char *UNVGetObjectFormalName(
	xsw_object_struct *obj_ptr,
	int obj_num
);
extern xsw_object_struct *UNVDupObject(xsw_object_struct *obj_ptr);
extern void UNVResetObject(xsw_object_struct *obj_ptr);
extern void UNVDeleteObject(xsw_object_struct *obj_ptr);
extern void UNVDeleteAllObjects(xsw_object_struct **obj_ptr, int total);

extern xsw_object_struct **UNVLoadFromFile(
	char *file,
	int *total,
	unv_head_struct *header_buf,
        void *client_data,
	void (*progress_notify)(void *, int, int)
);
extern int UNVSaveToFile(
	char *file,
	xsw_object_struct **obj_ptr,
	int total,
	unv_head_struct *header_buf,
        void *client_data,
        void (*progress_notify)(void *, int, int)
);

#endif	/* UNVFILE_H */
