/**********************************************************************
 * 
 * FILENAME:          xoj.c
 *
 * COPYRIGHT: Copyright 1994.  Integrated Silicon Systems, Inc.
 * ALL RIGHTS RESERVED.  DISTRIBUTION OF THIS FILE, OR CODE
 * COMPILED WITH IT, OR DERIVED FROM IT, IS STRICTLY PROHIBITED.
 * THIS SOFTWARE IS PROVIDED AS IS--NO WARRANTEE OF FITNESS FOR ANY
 * PURPOSE IS IMPLIED.
 *
 * DESCRIPTION:       OJ Simpson simulator
 *
 * EXPORTS:           
 *
 * NOTES:             
 *
 * NECESSARY FILES:
 *
 * REVISION HISTORY:
 * $Log$
 *
 **********************************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

typedef unsigned long Pixel;
typedef int ErrorHandler();

 
#include "vroot.h"  /* Use this if vroot.h installed in current directory */
 
#include <stdio.h>
#include <math.h>
#include <malloc.h>
#include <signal.h>
#include <limits.h>

#include "ojmap.h"



Display *display;
int screen;
Window rootWin;
int display_width, display_height;
int center_x, center_y;
GC gc;
char *display_name = NULL;
Pixel black, white;

int done = 0;
int eventBlock = 0;
int errorVal = 0;

unsigned int borderWidth = 0;

Region SubR;
Region WindowTops = NULL;
int ClearX, ClearY;

char *snowColor = "yellow";
char *slcColor = "black";
char *trColor = "aquamarine";

char *blackColor = "black";
char *redColor = "red";
char *whiteColor = "white";
char *bgColor = "none";
char *greenColor = "green"; 
char *blueColor = "blue"; 

Pixel redPix;
Pixel whitePix;
Pixel greenPix;
Pixel bluePix;
Pixel blackPix;
Pixel snowcPix;
Pixel bgPix;
Pixel trPix;
Pixel slcPix;

int theDelay = 12500; /* microseconds */
int BroncoSpeed = 2;
Bronco theBronco;

int n_cops = 6;
Cop *copcars;
Cop *copters;
Pixel *newscolors;


/* Forward declarations */
void SigHandler();
void InitCopter();
void DrawCopter();
void DrawGawk();
void EraseCopter();
void InitBronco();
void DrawBronco();
void EraseBronco();
void InitCop();
void UpdateBronco();
void UpdateCopter();
void UpdateCop();
void DrawCop();
void EraseCop();
void usleep();
Pixel AllocNamedColor();

void
main(ac, av)
int ac;
char *av[];
{
    XGCValues xgcv;
    int ax;
    char *arg;
    CopMap *np;
    CopMap *nbp;
    CopMap *cp;
    CopMap *cwp;
    CopMap *lp;
    BroncoMap *bp;
    BroncoMap *bwp;
    GawkMap *gp;
    GawkShirtMap *gsp;
    XEvent ev;
    int needCalc;
    int i; 

    /* Seed random */
    srand((int)time((long *)NULL));
    
    /*
       Catch some signals so we can erase any visible snowflakes.
    */
    signal(SIGKILL, SigHandler);
    signal(SIGINT, SigHandler);
    signal(SIGHUP, SigHandler);
    signal(SIGTERM, SigHandler);

    /*
       Process command line options.
    */
    for (ax=1; ax<ac; ax++){
      arg = av[ax];
      if (strcmp(arg, "-display") == 0){
	display_name = av[++ax];
      }
    }

    /* Open X */
    display = XOpenDisplay(display_name);
    if (display == NULL) {
	if (display_name == NULL) display_name = (char *)getenv("DISPLAY");
	(void) fprintf(stderr, "%s: cannot connect to X server %s\n", av[0],
	    display_name ? display_name : "(default)");
	exit(1);
    }

    screen = DefaultScreen(display);
    rootWin = RootWindow(display, screen);
    black = BlackPixel(display, screen);
    white = WhitePixel(display, screen);

    display_width = DisplayWidth(display, screen);
    display_height = DisplayHeight(display, screen) - 120;	/* jck */
    center_x = display_width / 2;
    center_y = display_height / 2;


    /*
        P I X M A P S 
    */


    /* Create the news helicopter pixmap */
    nbp = &newsbPix;
    nbp->pixmap = XCreateBitmapFromData( display, rootWin, nbp->copBits,
				       nbp->width, nbp->height );
    
    np = &newsPix;
    np->pixmap = XCreateBitmapFromData( display, rootWin, np->copBits,
				       np->width, np->height );
    
    /* Create the cop car pixmap */
    cp = &copPix;
    cp->pixmap = XCreateBitmapFromData( display, rootWin, cp->copBits,
				       cp->width, cp->height );
    
    cwp = &copwhitePix;
    cwp->pixmap = XCreateBitmapFromData( display, rootWin, cwp->copBits,
				       cwp->width, cwp->height );

    lp = &lightPix;
    lp->pixmap = XCreateBitmapFromData( display, rootWin, lp->copBits,
				       lp->width, lp->height );

    /* Allocate structures for cop cars */
    copcars = (Cop *)malloc( sizeof(Cop) * n_cops );
    copters = (Cop *)malloc( sizeof(Cop) * n_cops );
    newscolors = (Pixel *)malloc( sizeof(Pixel) * n_cops );
	       
    /* Pixmap for bronco */
    bp = &broncoPix;
    bp->pixmap = XCreateBitmapFromData( display, rootWin, bp->broncoBits,
				       bp->width, bp->height );
    
    bwp = &broncoblackPix;
    bwp->pixmap = XCreateBitmapFromData( display, rootWin, bwp->broncoBits,
				       bwp->width, bwp->height );


    /* Pixmap for onlookers */
    gp = &gawkPix;
    gp->pixmap = XCreateBitmapFromData( display, rootWin, gp->gawkBits,
				       gp->width, gp->height );
    gsp = &gawkShirtPix;
    gsp->pixmap = XCreateBitmapFromData( display, rootWin, gsp->gawkShirtBits,
				       gsp->width, gsp->height );

    /* Allocate colors just once */
    newscolors[0] = redPix =   AllocNamedColor(redColor, black);
    newscolors[1] = whitePix = AllocNamedColor(whiteColor, black);
    newscolors[2] = greenPix = AllocNamedColor(greenColor, black);
    newscolors[3] = bluePix = AllocNamedColor(blueColor, black);
    newscolors[4] = blackPix = AllocNamedColor(blackColor, black);
    newscolors[5] = snowcPix = AllocNamedColor(snowColor, white);   
	trPix = AllocNamedColor(trColor, black);
    slcPix = AllocNamedColor(slcColor, black); 

    gc = XCreateGC(display, rootWin, 0L, &xgcv);
    XSetForeground(display, gc, blackPix);
    XSetFillStyle(display, gc, FillStippled);

    /* Set the background color, if specified */
    if(strcmp(bgColor,"none") != 0) {
      bgPix = AllocNamedColor(bgColor, white);

      XSetWindowBackground(display, rootWin, bgPix);
      XClearWindow(display, rootWin);
      XFlush(display);
    }
    
    /* People */
    DrawGawk();    
    
    /* Initialize all cop cars */
    for (i=0; i< n_cops; i++) {
		InitCop(i);
		InitCopter(i);
	}

    InitBronco();   

    /* Notify if part of the root window changed */
    XSelectInput(display, rootWin, ExposureMask | SubstructureNotifyMask);

    needCalc = 0;
/*    if (!NoKeepSnow) needCalc = CalcWindowTops(); */


    /*
     *  M A I N   L O O P
     */
    while (!done) {

/*      SnowTicks--;   
      if (SnowTicks == 0) SnowTicks = ULONG_MAX; */

      /* X event ? */
      /* Handle all the expose events and redo CalcWindowTops after */
      while (XPending(display)) {
        XNextEvent(display, &ev);
       
      }  /* while Xpending */

      /* If things have changed while we were away... */
/*      if (needCalc) needCalc = CalcWindowTops(); */


      /* 
       *  Update     
       */

      for (i=0; i< n_cops; i++) {
		UpdateCop(i);
		UpdateCopter(i);
	  }

      /* The bronco */
      XSetForeground(display, gc, slcPix);
      UpdateBronco();

      /* Sleep a bit */
      usleep(theDelay);
    }
    
    XClearWindow(display, rootWin);

    XCloseDisplay(display);

    exit(0);
}
  
/* Initialize the i'th copter */
void InitCopter( i )
int i;
{
  copters[i].x = (i%2 ? 0 : 300);
  copters[i].y = copcars[i].y + 5;

  copters[i].xStep = BroncoSpeed;
  copters[i].yStep = 1;
}

/* Initialize the i'th cop car */
void InitCop( i )
int i;
{
  copcars[i].x = 100;
  copcars[i].y = RandInt( display_height / 2 / n_cops - 32 ) + 
                     i * (display_height/ 2 / n_cops ) + 100;	/* jck */

  copcars[i].xStep = BroncoSpeed;
  copcars[i].yStep = 0;

  /* Color of flashing light */ 
  copcars[i].color = i % 2;
}


/* Update position of cop i */
void UpdateCop( i )
int i;
{
  EraseCop(i);

  /* Move forward */
  copcars[i].x = copcars[i].x + copcars[i].xStep;
 
  /* Cop cars stay at the same height */

  if (copcars[i].x >= display_width)
  {
	InitCop(i);
	copcars[i].x = 0; 
  }

  copcars[i].color = 1 - copcars[i].color;

  DrawCop(i);
}

/* Update position of copter i */
void UpdateCopter( i )
int i;
{
  EraseCopter(i);

   /* Copters move around!  - dennisf@denix.elk.miles.com */
   copters[i].x += theBronco.xStep;  /* keep up with theBronco */
   if (RandInt(10) > 3) copters[i].x += copters[i].xStep; 
   if (copters[i].x < 0) copters[i].x = display_width;
   if (copters[i].x > display_width) copters[i].x = 0;
   if (RandInt(10) > 8) copters[i].xStep = -copters[i].xStep;
 
   if (RandInt(10) > 3) copters[i].y += copters[i].yStep; 
   if (copters[i].y < 0) copters[i].y = display_height;
   if (copters[i].y > display_height) copters[i].y = 0;
   if (RandInt(10) > 8) copters[i].yStep = -copters[i].yStep;

  DrawCopter(i);
}  


/* Redraw cop number i */
void
DrawCop( i )
int i;
{
  XSetForeground( display, gc, blackPix );
  XSetStipple(display, gc, copPix.pixmap);
  XSetTSOrigin(display, gc, copcars[i].x, copcars[i].y);
  XFillRectangle(display, rootWin, gc,
         copcars[i].x, copcars[i].y,
         copPix.width, copPix.height );

  XSetForeground( display, gc, whitePix );
  XSetStipple(display, gc, copwhitePix.pixmap);
  XSetTSOrigin(display, gc, copcars[i].x, copcars[i].y);
  XFillRectangle(display, rootWin, gc,
         copcars[i].x, copcars[i].y,
         copwhitePix.width, copwhitePix.height );

  /* Flash the lights red & blue, alternatingly */
  if ( copcars[i].color == 0 ){
    XSetForeground( display, gc, redPix );
  }
  else{
    XSetForeground( display, gc, bluePix );
  }

  XSetStipple(display, gc, lightPix.pixmap);
  XSetTSOrigin(display, gc, copcars[i].x, copcars[i].y);
  XFillRectangle(display, rootWin, gc,
         copcars[i].x, copcars[i].y,
         lightPix.width, lightPix.height );


}

/* Redraw cop number i */
void
DrawCopter( i )
int i;
{
  XSetForeground( display, gc, newscolors[i] );
  XSetStipple(display, gc, (i % 2 ? newsPix.pixmap : newsbPix.pixmap));
  XSetTSOrigin(display, gc, copters[i].x, copters[i].y);
  XFillRectangle(display, rootWin, gc,
         copters[i].x, copters[i].y,
         newsPix.width, newsPix.height );
}


/* Redraw onlookers */
void
DrawGawk( )
{
  int gawkx,gawky,i,gawk_max;
  int ngawk = 40;
  int gawkyarr[2];

  gawk_max = display_height + 120;
  gawkyarr[0] = gawk_height + 5;
  gawkyarr[1] = gawk_max/2 + gawk_height + 5;


  for (i=0;i<ngawk;i++) {
     gawkx = RandInt(display_width);
     /*gawkers will be placed randomly over 20 pixels */
     gawky = gawkyarr[i % 2] + ( (((i % 2) * 2) - 1) * (int) (5.0 * exp(3.5 * RandInt(100)/100)) );
/*
     gawky = gawkyarr[i % 2]+ RandInt(20);
/**/
     XSetForeground( display, gc, blackPix );
     XSetStipple(display, gc, gawkPix.pixmap);
     XSetTSOrigin(display, gc, gawkx, gawky);
     XFillRectangle(display, rootWin, gc,
            gawkx, gawky,
            gawkPix.width, gawkPix.height );

     XSetForeground( display, gc, newscolors[RandInt(5)] );
     XSetStipple(display, gc, gawkShirtPix.pixmap);
     XSetTSOrigin(display, gc, gawkx, gawky);
     XFillRectangle(display, rootWin, gc,
            gawkx, gawky,
            gawkShirtPix.width, gawkShirtPix.height );
  }
}

/* Erase copter i */
void
EraseCopter( i )
{
  if (copters[i].x >= 0) 
      XClearArea(display, rootWin,
                 copters[i].x , copters[i].y,     
                 newsPix.width, newsPix.height, False);
}

/* Erase cop i */
void
EraseCop( i )
{
  if (copcars[i].x >= 0) 
      XClearArea(display, rootWin,
                 copcars[i].x , copcars[i].y,     
                 copPix.width, copPix.height, False);
}



/*
   Give birth to a Bronco. (What a conception)
*/
void
InitBronco()      
{
  theBronco.x = 200;
  theBronco.y = RandInt(display_height / 3)+80;
  theBronco.xStep = BroncoSpeed;
  theBronco.yStep = 1;
}



/*
  Update Bronco
*/
void
UpdateBronco()
{
  EraseBronco();

  /* Move forward */
  theBronco.x = theBronco.x + theBronco.xStep;
 
  /* Move down */
  if (RandInt(10) > 3) theBronco.y = theBronco.y + theBronco.yStep; 
  if (theBronco.y < 0) theBronco.y = 0;
  if (RandInt(100) > 80) theBronco.yStep = -theBronco.yStep;

  if (RandInt(100) > 95) DrawGawk();

  if (theBronco.x >= display_width) theBronco.x = 0;

  DrawBronco();
}




/*
  Draw Bronco
*/
void
DrawBronco()
{
  XSetForeground( display, gc, whitePix );
  XSetStipple(display, gc, broncoPix.pixmap);
  XSetTSOrigin(display, gc, theBronco.x, theBronco.y);
  XFillRectangle(display, rootWin, gc,
         theBronco.x, theBronco.y,
         broncoPix.width, broncoPix.height );

  XSetForeground( display, gc, blackPix );
  XSetStipple(display, gc, broncoblackPix.pixmap);
  XSetTSOrigin(display, gc, theBronco.x, theBronco.y);
  XFillRectangle(display, rootWin, gc,
         theBronco.x, theBronco.y,
         broncoblackPix.width, broncoblackPix.height );

}

/*
  Erase Bronco
*/
void
EraseBronco()
{
  if (theBronco.x >= 0) 
      XClearArea(display, rootWin,
                 theBronco.x , theBronco.y,     
                 broncoPix.width, broncoPix.height, False);
}



void
SigHandler(sig)
int sig;
{
  printf("Caught Signal [%d]\n", sig);
  if (sig != SIGHUP)
	done = 1;
}


/*
   Generate random integer between 0 and maxVal-1.
*/
int
RandInt(maxVal)
int maxVal;
{
	return rand() % maxVal;
}


/*
 * sleep for a number of micro-seconds
 */
void usleep(usec) 
unsigned long usec;
{
#ifdef SVR3
    poll((struct poll *)0, (size_t)0, usec/1000);   /* ms resolution */
#else
    struct timeval t;
    t.tv_usec = usec%(unsigned long)1000000;
    t.tv_sec = usec/(unsigned long)1000000;
    select(0, (void *)0, (void *)0, (void *)0, &t);
#endif
}




/*
   Allocate a color by name.
*/
Pixel
AllocNamedColor(colorName, dfltPix)
char *colorName;
Pixel dfltPix;
{
	Pixel pix;
	XColor scrncolor;
	XColor exactcolor;

	if (XAllocNamedColor(display, DefaultColormap(display, screen),
		colorName, &scrncolor, &exactcolor)) {
		pix = scrncolor.pixel;
	}
	else {
		pix = dfltPix;
	}

	return pix;
}
