#include "xev.h"
#include "enemy.h"

PRIVATE char *fn[] = {
      "teraji1.img",
      "teraji2.img",
      "teraji3.img",
      "teraji4.img",
      "teraji5.img"
};
PRIVATE Pixmap pixmap[5];
PRIVATE Pixmap pixmap_mask[5];
PRIVATE GC gc[5];
PRIVATE int shot_p[5][3] = {
      {35,45,50},
      {40,48,55},
      {55,60,70},
      {65,75,85},
      {90,100,120}
};

void TerajiSetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[128];
      XGCValues gcv;

      gcv.graphics_exposures = True;
      for(c_no = 0 ; c_no < 5 ; c_no++) {
            int x,y;
            
            sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img , sizeof(img));

            pixmap[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
            bzero(mask , sizeof(mask));
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);

	    DrawChar32(img , mask , gc[c_no],pixmap[c_no]);
            pixmap_mask[c_no] 
              = XCreateBitmapFromData(d,w,mask,CSIZE,CSIZE);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
}

void TerajiFree()
{
      int i;

      for(i = 0 ; i < 5 ; i++) {
	    XFreePixmap(d,pixmap[i]);
	    XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

void TerajiInit(enemy_no)
     int enemy_no;
{
      int v, sgnx,sgny,absxy;


      enemy[enemy_no].enemy_no = TERAJI;
      enemy[enemy_no].tmp1 = -36000;
      enemy[enemy_no].tmp2 = 0;
      
      
      enemy[enemy_no].x.dummy = 65536*(rand() % XSIZE);
      enemy[enemy_no].y.dummy = -32*65536;

      sgnx = jx.sht[UNION] - enemy[enemy_no].x.sht[UNION];
      sgny = jy.sht[UNION] - enemy[enemy_no].y.sht[UNION];
      absxy = 1+ABS(sgnx) + ABS(sgny);

      v = (rand() % 8+ 9)*STPF;
      enemy[enemy_no].vx = v*sgnx*38000/absxy;
      enemy[enemy_no].vy = v*sgny*49000/absxy;
}

int Teraji(enemy_no)
     int enemy_no;
{
      int i;
      int yararetaTL = 0;
      int dx,dy;
      int sx,sy;
      int anim = 0;

      enemy[enemy_no].x.dummy += enemy[enemy_no].vx;
      enemy[enemy_no].y.dummy += enemy[enemy_no].vy;
      sx = enemy[enemy_no].x.sht[UNION];
      sy = enemy[enemy_no].y.sht[UNION];
      enemy[enemy_no].vy += enemy[enemy_no].tmp1;
      dx = jx.sht[UNION] - sx; dy = jy.sht[UNION] - sy;
      
      if(dx > -20 && dx < 20 && dy > -20 && dy < 20)
        yararetaTL = 1;
      
      for(i = 0 ; i < SHOT_NUM ; i++)
        {
              if(!shot[i].flag)
                continue;
	      
	      if((shot[i].x.sht[UNION] - sx) > -20 && 
		 (shot[i].x.sht[UNION] - sx) < 20
		 && (shot[i].y.sht[UNION] - sy) > -24 && 
		 (shot[i].y.sht[UNION] - sy) < 24)
		{
		      score += 700;
		      shot[i].flag = 0;
                      BombInit(enemy_no);
		      return 0;
                }
        }
      
      if(sx < 0 ||sx > XSIZE
         || sy > YSIZE)
	{
              enemy[enemy_no].enemy_no = 0;
        }
      else
        {
	      if(enemy[enemy_no].vy >= 0)
		anim = 0;
	      if(enemy[enemy_no].vy < 0 &&  enemy[enemy_no].vy >= -2*65536)
		anim = 1;
	      if(enemy[enemy_no].vy < -2*65536 && enemy[enemy_no].vy >= -3*65536)
                anim = 2;
	      if(enemy[enemy_no].vy < -3*65536 && enemy[enemy_no].vy >= -4*65536)
                anim = 3;
	      if(enemy[enemy_no].vy < -4*65536)
                anim = 4;

	      
	      if(enemy[enemy_no].vy < 65536 && (rand() & 127) 
		 < shot_p[game_level][level])
		EShut(enemy_no,enemy[enemy_no].x.dummy,
		      enemy[enemy_no].y.dummy);
	      
	      SetSprite(enemy[enemy_no].x.sht[UNION],
			enemy[enemy_no].y.sht[UNION],
			pixmap[anim],
			gc[anim],
			CSIZE,CSIZE);
        }
      
      return yararetaTL;
}





