## vim:ts=4:et:nowrap
##
##---------------------------------------------------------------------------##
##
## PySol -- a Python Solitaire game
##
## Copyright (C) 1999 Markus Franz Xaver Johannes Oberhumer
## Copyright (C) 1998 Markus Franz Xaver Johannes Oberhumer
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING.
## If not, write to the Free Software Foundation, Inc.,
## 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
##
## Markus F.X.J. Oberhumer
## <markus.oberhumer@jk.uni-linz.ac.at>
## http://wildsau.idv.uni-linz.ac.at/mfx/pysol.html
##
##---------------------------------------------------------------------------##


# imports
import os, sys
import traceback                                                    #bundle#


# /***********************************************************************
# // just a placeholder for now
# ************************************************************************/

class PysolAudio:
    def __init__(self, app):
        self.app = app
        self.audiodev = None
        self.mididev = None
        self.__initAudio()
        self.__initMidi()
        if self.audiodev is None and self.mididev is None:
            self.app = None

    def destroy(self):
        self.app = None

    def __initAudio(self):
        # init audio
        if 0 and os.name == "nt":
            try:
                import winsound
                self.audiodev = winsound
            except: pass
        if 0:
            try:
                import audiodev
                self.audiodev = audiodev.AudioDev()
                ##print app.audiodev.__dict__
            except: pass

    def __initMidi(self):
        pass


    def playSample(self, name):
        if self.audiodev is None or not self.app.opt.sound:
            return
        a = self.audiodev
        try:
            name = self.app.dataloader.findFile(name, "sounds")
            if os.name == "nt":
                flags = a.SND_FILENAME | a.SND_ASYNC | a.SND_NODEFAULT | a.SND_NOWAIT;
                a.PlaySound(name, flags)
        except:
            if 1: traceback.print_exc()                           #bundle#
            pass

    def playMidi(self, name):
        if self.mididev is None or not self.app.opt.sound:
            return


