/*
 *  Copyright (C) 1999 Peter Amstutz
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of *the
 *  License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307 USA 
 */

#include "weapon.h"
#include "../gfx.h"

#include "simplegfx.h"
#include "dirtgfx.h"
#include "napalmgfx.h"

void wgxSetWeaponDrawFunc(char *name,
						  void (*drawshot)(struct Projectilepos_bal *prjpos, void* info),
						  void (*drawexplosion)(void* info))
{
    Weapon_wep *wcur;
    
    wcur=wepLookupWeapon(name);
    if(wcur==NULL) return;
    wcur->drawshot=drawshot; 
    wcur->drawexplosion=drawexplosion;
}

void wgxInit()
{
    wgxSetWeaponDrawFunc("Basic Shell", wgxDrawSimpleShot, wgxDrawSimpleExplosion);
    wgxSetWeaponDrawFunc("Large Shell", wgxDrawSimpleShot, wgxDrawSimpleExplosion);
    wgxSetWeaponDrawFunc("Tac Nuke", wgxDrawSimpleShot, wgxDrawSimpleExplosion);
    wgxSetWeaponDrawFunc("Super Nuke", wgxDrawSimpleShot, wgxDrawSimpleExplosion);
    wgxSetWeaponDrawFunc("Cluster Bomb", wgxDrawSimpleShot, NULL);
    wgxSetWeaponDrawFunc("Cluster Fragment", wgxDrawSimpleShot, wgxDrawSimpleExplosion);
    wgxSetWeaponDrawFunc("MIRV", wgxDrawSimpleShot, wgxDrawSimpleExplosion);
    wgxSetWeaponDrawFunc("Dirt Ball", wgxDrawSimpleShot, wgxDrawDirtExplosion);
    wgxSetWeaponDrawFunc("Roller", wgxDrawSimpleShot, NULL);
    wgxSetWeaponDrawFunc("Roller Ball", wgxDrawSimpleShot, wgxDrawSimpleExplosion);
    wgxSetWeaponDrawFunc("Death From Above", wgxDrawSimpleShot, wgxDrawSimpleExplosion);
    wgxSetWeaponDrawFunc("Funky Bomb", wgxDrawSimpleShot, wgxDrawSimpleExplosion);
	wgxSetWeaponDrawFunc("Tunneler", wgxDrawSimpleShot, wgxDrawSimpleExplosion);
	wgxSetWeaponDrawFunc("Napalm", wgxDrawSimpleShot, wgxDrawSimpleExplosion);
	wgxSetWeaponDrawFunc("Burning Napalm", wgxDrawBurningNapalmShot, wgxDrawBurningNapalmExplosion);
}
