
#ifndef SCRAM_HH
#define SCRAM_HH

// Copyright (c) 1995-1999 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Author: Dale E. Martin          dmartin@ece.uc.edu

//---------------------------------------------------------------------------
//
// $Id: scram.hh,v 1.2 1999/03/09 20:57:25 dmartin Exp $
//
//---------------------------------------------------------------------------

#include "savant.hh"
template <class type> class dl_list;
class IIR_DesignFile;
class IIR_DesignFileList;
class IIR_LibraryDeclaration;
#include <stdio.h>
class symbol_table;
class library_manager;

class scram {
public:
  // This is the constructor that should be called for the first scram
  // instantiated.
  scram( library_manager * );
  
  scram( );

  ~scram();
    
  // This method parses the files passed in and returns a list of savant_if
  // IIR_DesignFiles.
  IIR_DesignFileList *parse_files( int, char ** );
  IIR_DesignFile *parse_file( char *, IIR_LibraryDeclaration * );

  symbol_table *get_symbol_table(){
    return my_symbol_table;
  }

  library_manager *get_library_manager(){
    return my_library_manager;
  }


private:
  // This method prepares the symbol table for use.  It parses
  // "std.standard".
  void make_ready();
  
  symbol_table *my_symbol_table;
  static library_manager *my_library_manager;

  bool need_to_write_libraries;
};

#endif
