// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_PackageBodyDeclaration.cc,v 1.3 1999/03/12 16:08:30 dmadhava Exp $
// 
//---------------------------------------------------------------------------

#include "IIRScram_PackageBodyDeclaration.hh"
#include "IIR_Identifier.hh"
#include <strstream.h>
#include "IIR_ConstantDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_TypeDeclaration.hh"
#include "symbol_table.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_PackageBodyDeclaration::IIRScram_PackageBodyDeclaration() {
  cgen_sym_tab_ptr = NULL;
}

IIRScram_PackageBodyDeclaration::~IIRScram_PackageBodyDeclaration() {}

void 
IIRScram_PackageBodyDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  PublishedUnit oldUnit;
  
  context_items._publish_vhdl(_vhdl_out);

  oldUnit = _get_currently_publishing_vhdl_unit();
  _set_currently_publishing_vhdl_unit(IIRScram::PACKAGE_BODY);
  
  _vhdl_out << "package body ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " is\n";
  package_declarative_part._publish_vhdl_decl(_vhdl_out);
  _vhdl_out << "end package body ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n";

  _set_currently_publishing_vhdl_unit(oldUnit);
}

void 
IIRScram_PackageBodyDeclaration::_publish_cc_package_name() {
  _get_declarator()->_publish_cc();
  _cc_out << "Pkg";
}

void 
IIRScram_PackageBodyDeclaration::_publish_cc() {
  ostrstream package_body_name;
  symbol_table cgen_sym_tab( 4093, false );
  
  _set_currently_publishing_unit(IIRScram::PACKAGE_BODY);

  cgen_sym_tab_ptr = &cgen_sym_tab;

  _publish_cc_hh_file();
  _publish_cc_cc_file();

  package_body_name << *_get_declarator() << "Pkg" << ends;
  _current_package_body_name = package_body_name.str();

  cgen_sym_tab_ptr = NULL;

  delete [] package_body_name.str();
  _set_currently_publishing_unit(NONE);
}

void
IIRScram_PackageBodyDeclaration::_publish_cc_hh_file() {
  IIR_Char *buf;
  strstream str;
  str << *_get_declarator() << ends;
  buf = str.str();
  _cc_out.set_file(true, buf, "Pkg.hh");

  _cc_out << "#ifndef ";
  _publish_cc_package_name();
  _cc_out << "_Body_HH" << endl
	  << "#define ";
  _publish_cc_package_name();
  _cc_out << "_Body_HH" << endl;

  context_items._publish_cc();
  _publish_cc_headers();
 
  package_declarative_part._publish_cc_extern_type_info();
  package_declarative_part._publish_cc_package_declarations();

  _cc_out.set_file(true, buf, "Pkg.hh");
  _cc_out << "#endif" << endl;
  delete [] buf;
}

void
IIRScram_PackageBodyDeclaration::_publish_cc_cc_file() {
  IIR_Char *buf;
  strstream str;
  str << *_get_declarator() << ends;
  buf = str.str();
  _cc_out.set_file(TRUE, buf, "Pkg.cc");
  
  IIR_Declaration *decl = package_declarative_part.first();

  _cc_out << "#include \"" << buf << "Pkg.hh\"\n" << endl;

  // first publish all the constants and then the other types, since
  // the other types might be using this constant information in their
  // declaration.
  for(;decl != NULL; decl = package_declarative_part.successor(decl)){
    switch(decl->get_kind()){
    case IIR_CONSTANT_DECLARATION:
      ((IIR_ConstantDeclaration *) decl)->_publish_cc_init_package_constant();
      break;
    default:
      break;
    }
  }

  //initialize the decl
  decl = package_declarative_part.first();
  for(;decl != NULL; decl = package_declarative_part.successor(decl)) {
    switch(decl->get_kind()) {
    case IIR_CONSTANT_DECLARATION:
      //nothing to do since already published
      break;
    case IIR_TYPE_DECLARATION:
    case IIR_SUBTYPE_DECLARATION:
      break;
    case IIR_PROCEDURE_DECLARATION:
    case IIR_FUNCTION_DECLARATION:
      decl->_publish_cc_decl();
      break;
    case IIR_COMPONENT_DECLARATION:
      break;
    case IIR_USE_CLAUSE:
      break;
    default:
      cerr << "Unimplemented declaration type: " << decl->get_kind_text()
	   << " in IIRScram_PackageBodyDeclaration::_publish_cc_cc_file()." 
	   << endl;
      break;
    }
  }
  delete [] buf;

  package_declarative_part._publish_cc_type_info();
}

void 
IIRScram_PackageBodyDeclaration::_publish_cc_headers() {
  IIR_Declaration *decl = package_declarative_part.first();
  set<IIR> headerSet;

  while (decl != NULL) {
    switch(decl->get_kind()) {
    case IIR_TYPE_DECLARATION:
    case IIR_SUBTYPE_DECLARATION:
      headerSet.add(decl);
      break;
    case IIR_FUNCTION_DECLARATION:
    case IIR_PROCEDURE_DECLARATION:
      decl->_get_headers(headerSet);
      break;
    case IIR_COMPONENT_DECLARATION:
      _cc_out << "#include \"SCOM";
      (decl->_get_declarator())->_publish_cc_elaborate();
      _cc_out << "_elab.hh\"\n";
      break;
    case IIR_USE_CLAUSE:
      decl->_publish_cc_headers();
      break;
    case IIR_SHARED_VARIABLE_DECLARATION:
    case IIR_FILE_DECLARATION:
    case IIR_ALIAS_DECLARATION:
    case IIR_ATTRIBUTE_DECLARATION:
    case IIR_ATTRIBUTE_SPECIFICATION:
    case IIR_DISCONNECT_SPECIFICATION:
    case IIR_GROUP_DECLARATION:
    case IIR_GROUP_TEMPLATE_DECLARATION:
      cerr << decl->get_kind_text() << " not supported in package yet" << endl;
      break;
    case IIR_CONSTANT_DECLARATION:
      break;
    default:
      cerr << "IIRScram_PackageBodyDeclaration.cc::_publish_cc_headers():"
	   << " Unknown declaration type: " << decl->get_kind_text() << endl;
      break;
    }
    decl = package_declarative_part.successor(decl);
  }
  
  // Walk through the collected set of type declarations and publish headers
  IIR *typDecl = headerSet.get_element();
  while (typDecl != NULL) {
    _cc_out << "#include \"";
    typDecl->_publish_cc_type_name();
    _cc_out << ".hh\"" << endl;
    typDecl = headerSet.get_next_element();
  }
}  

void
IIRScram_PackageBodyDeclaration::_publish_cc_elaborate() {
}

IIRScram_Declaration::declaration_type 
IIRScram_PackageBodyDeclaration::_get_type(){
   return PACKAGE_BODY;
}

