// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_LessThanOperator.cc,v 1.2 1999/03/09 20:55:17 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_LessThanOperator.hh"

IIRScram_LessThanOperator::~IIRScram_LessThanOperator() {}

void 
IIRScram_LessThanOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " < ";
}

void 
IIRScram_LessThanOperator::_publish_cc_operator_name() {
  _cc_out << "savantLessThan";
}


IIR*
IIRScram_LessThanOperator::_clone() {
  IIR_LessThanOperator *clone = new IIR_LessThanOperator();
  IIRScram_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_LessThanOperator::_get_operator_precedence(){
  return IIRScram::RELATIONAL_OPERATOR;
}

IIR_Boolean                                      
IIRScram_LessThanOperator::_is_relational_operator(){
  return TRUE ;                                                              
}

