// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_FloatingTypeDefinition.cc,v 1.3 1999/08/02 12:50:03 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIR_FloatingSubtypeDefinition.hh"
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIRScram_FloatingPointLiteral.hh"
#include "StandardPackage.hh"

IIRScram_FloatingTypeDefinition::~IIRScram_FloatingTypeDefinition() {}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_decl_cc() {
  _publish_cc_define_type_attributes();
}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_left() {
  ASSERT(get_left() != NULL);
  
  get_left()->_publish_cc();
}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_right() {
  ASSERT(get_right() != NULL);

  get_right()->_publish_cc();
}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_universal_type() {
  _cc_out << "UniversalReal";
}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_kernel_type() {
  _cc_out << "RealType";
}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_attribute_image() {
  _cc_out << "const SavantstringType " << endl;
  _publish_cc_type_name();
  _cc_out << "::IMAGE(const ";
  _publish_cc_base_type_name();
  _cc_out << "& x"
	  << ") {" << endl;

  _cc_out << "UniversalReal value;" << endl
	  << "value = x.getObject()->readVal();" << endl
	  << "strstream string;" << endl
	  << "string << value << ends;" << endl
	  << "char* ptr = string.str();" << endl
	  << "SavantstringType image(ObjectBase::VARIABLE,0,to,strlen(ptr)-1,ptr);"
	  << endl
	  << "return image;" << endl
	  << "}" << endl;
}


void 
IIRScram_FloatingTypeDefinition::_publish_cc_attribute_value() {
  _cc_out << "const ";
  _publish_cc_base_type_name();
  _cc_out << endl;
  _publish_cc_type_name();
  _cc_out << "::VALUE(const SavantstringType& x) {" << endl;

  _cc_out << "  int length = x.get_number_of_elements();" << endl
	  << "  strstream value;" << endl
	  << "  char* ptr;" << endl
	  << "  for(int i=0; i < length; i++) {" << endl
	  << "    x.get_element(i).print(value);" << endl
	  << "  }" << endl
	  << "  value << ends;" << endl
	  << "  ptr = value.str();" << endl
	  << "  double val = atof(ptr);" << endl << "  ";
  _publish_cc_type_name();
  _cc_out << " retval(ObjectBase::VARIABLE, UniversalReal(val));" << endl
	  << "  return retval;" << endl
	  << "}" << endl;
}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_data_members() {
  //I have nothing to do here.
  //But I stop system from crying undefined function blah, blah, blah...
}

IIR_TypeDefinition *
IIRScram_FloatingTypeDefinition::_check_special_compatible( IIR_TypeDefinition *to_check ){
  if( ((IIR_FloatingTypeDefinition *)this == StandardPackage::savant_universal_real &&
       to_check->_is_floating_type() == TRUE )
      ||
      (IIR_FloatingTypeDefinition *)to_check == StandardPackage::savant_universal_real ){
    return StandardPackage::savant_universal_real;
  }
  else{
    return NULL;
  }
}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_type_info(){
  _cc_out << "realInfo ";
  _publish_cc();
  _cc_out << "_info(";
  get_left()->_publish_cc_universal_value();
  _cc_out << ", ";
  if(get_direction()->_is_ascending_range() == TRUE) {
    _cc_out << "to, ";
  }
  else {
    _cc_out << "downto, ";
  }
   get_right()->_publish_cc_universal_value();
  _cc_out << ")";
}

void
IIRScram_FloatingTypeDefinition::_publish_cc_extern_type_info(){
  _cc_out << "extern realInfo ";
  _publish_cc();
  _cc_out << "_info;" << endl;
} 

void 
IIRScram_FloatingTypeDefinition::_publish_cc_type_string(){
  _cc_out << "RealType";
}

IIR_TypeDefinition *
IIRScram_FloatingTypeDefinition::_get_new_subtype(){
  IIR_TypeDefinition *retval = new IIR_FloatingSubtypeDefinition();
  copy_location( this, retval );
  return retval;
}

IIR *
IIRScram_FloatingTypeDefinition::_clone(){
  IIR_FloatingTypeDefinition *retval;
  IIR_TypeDefinition *temp = _get_new_subtype();

  ASSERT( temp->_is_iir_floating_type_definition() == TRUE );
  retval = (IIR_FloatingTypeDefinition *)temp;
  IIR_ScalarTypeDefinition::_clone( retval );

  return retval;
}

void 
IIRScram_FloatingTypeDefinition::_build_implicit_operators( set<IIR_Declaration> *add_to ){
  char *multiplying_operators[] = {"\"*\"", "\"/\"", NULL };
  IIR_ScalarTypeDefinition::_build_implicit_operators( add_to );
  IIR_TypeDefinition::_build_implicit_operators( multiplying_operators,
						 add_to,
						 this,
						 this,
						 this );

  IIR_TypeDefinition *integer_type = StandardPackage::integer_type;
  IIR_TypeDefinition::_build_implicit_operator( "\"**\"", add_to, this, this, integer_type );  
}
