#ifndef IIRSCRAM_CONSTANT_DECLARATION_HH
#define IIRSCRAM_CONSTANT_DECLARATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ConstantDeclaration.hh,v 1.2 1999/03/09 20:53:49 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_ConstantDeclaration.hh"

class IIRScram_ConstantDeclaration : public IIRBase_ConstantDeclaration {
public:
  void _publish_vhdl_decl( ostream & );
  void _publish_vhdl_range( ostream & );
  void _publish_cc_decl();
  void _publish_cc_elaborate();
  void _publish_cc();
  void _publish_cc_init();
  void _publish_cc_constant_object_init();
  void _publish_cc_scalar_init();
  void _publish_cc_composite_init();
  void _publish_cc_access_init();
  void _publish_cc_file_init();
  void _publish_cc_data();
  void _publish_cc_wait_data();
  void _publish_cc_universal_value();
  void _publish_cc_value();
  void _publish_cc_left();
  void _publish_cc_right();
  void _publish_cc_universal_left();
  void _publish_cc_universal_right();
  void _publish_cc_init_package_constant();
  void _publish_cc_state_object_init();
  void _publish_cc_object_type();
  void _publish_cc_initialization_value();
  void _publish_cc_headers();
  void _publish_cc_decl_with_constructor_args();
  void _set_scoping_prefix();
  
  IIR_Boolean _is_constant(){ return TRUE; }
  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return FALSE; }
  IIR_Boolean _is_static_expression();

  IIR_Boolean _is_ascending_range();
  IIR_Boolean _is_implicit_declaration();
  
  IIR_Boolean _is_locally_static_primary();
  IIR_Boolean _is_globally_static_primary();

  // The iteration scheme in For Loop Statement, which is a constant
  // declaration could have a range attribute in it's range.  This is
  // represented by a Range Attribute name returned by
  // IIR_TypeDefinition::_get_attribute().  This method checks this.
  IIR_Boolean _is_range_attribute();
  IIR_Attribute* _get_attribute();
  declaration_type _get_type();
  
  IIR *_clone();

protected:
  IIRScram_ConstantDeclaration() {};
  virtual ~IIRScram_ConstantDeclaration() = 0;
    
private:
};
#endif



