#ifndef IIRSCRAM_ASSERTION_STATEMENT_HH
#define IIRSCRAM_ASSERTION_STATEMENT_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_AssertionStatement.hh,v 1.2 1999/03/09 20:52:57 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_AssertionStatement.hh"

class IIR_List;
template <class type> class set;

class IIRScram_AssertionStatement : public IIRBase_AssertionStatement {

public:
  void _publish_vhdl(ostream &);
  void _publish_cc();
  
  // Just to keep _report_undefined_scram_fn quiet
  void _get_list_of_input_signals(set<IIR_Declaration>*);

  void _type_check();
  IIR *_clone();

  IIR *_get_assertion_condition(){ return get_assertion_condition(); }
  void _set_assertion_condition( IIR *new_expr ){ set_assertion_condition( new_expr ); }
  
  IIR *_get_report_expression(){ return get_report_expression(); }
  void _set_report_expression( IIR *new_expr ){ set_report_expression( new_expr ); }
  
  IIR *_get_severity_expression(){ return get_severity_expression(); }
  void _set_severity_expression( IIR *new_expr ){ set_severity_expression( new_expr ); }


protected:  
  IIRScram_AssertionStatement() {};
  virtual ~IIRScram_AssertionStatement() = 0;
    
private:
};
#endif
