#ifndef IIRSCRAM_ARRAY_SUBTYPE_DEFINITION_HH
#define IIRSCRAM_ARRAY_SUBTYPE_DEFINITION_HH
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRScram_ArraySubtypeDefinition.hh,v 1.2 1999/03/09 20:52:52 dmartin Exp $
// 
//---------------------------------------------------------------------------
#include "IIRBase_ArraySubtypeDefinition.hh"
#include "IIR_ArrayTypeDefinition.hh"

class IIRScram_ArraySubtypeDefinition : public IIRBase_ArraySubtypeDefinition {

public:
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_subtype_decl(ostream &_vhdl_out);
  virtual IIR_Boolean _is_subtype();

  ostream& _print(ostream& os);
  void _publish_cc_type_name();
  void _publish_cc_bounds();
  void _publish_cc_headers();
  void _publish_cc_decl_array_type_attributes();
  void _publish_cc_define_array_type_attributes();

  void _publish_cc_decl_constructor_prototypes();
  void _publish_cc_define_constructors();
  void _publish_cc_decl_destructors();

  void _publish_cc_attribute_constructor_arguments();

  void _publish_cc_decl_class_event_constructor();
  void _publish_cc_decl_class_event_destructor();
  void _publish_cc_class_event_constructor_with_no_value();
  void _publish_cc_class_event_constructor_with_aggregates();
  void _publish_cc_constructor_for_multidimension_alias_init();
  void _publish_cc_decl_class_last_event_constructor();
  void _publish_cc_decl_class_last_event_destructor();
  void _publish_cc_class_last_event_constructor_with_no_value();
  void _publish_cc_class_last_event_constructor_with_aggregates();
  void _publish_cc_type_info();
  void _publish_cc_extern_type_info();

  IIR_ScalarTypeDefinition *_get_index_subtype();

  IIR *_clone();

  IIR_FunctionDeclaration* _get_resolution_function(){ return get_resolution_function(); }
  void _set_resolution_function(IIR_FunctionDeclaration *new_function ){
    set_resolution_function( new_function );
  }

  IIR_Boolean _is_locally_static();
  IIR_Boolean _is_globally_static();
  
protected:
  IIRScram_ArraySubtypeDefinition() {}
  virtual ~IIRScram_ArraySubtypeDefinition() = 0;
    
private:
  void _publish_cc_define_type_attribute_left();
  void _publish_cc_define_type_attribute_right();
  void _publish_cc_define_type_attribute_low();
  void _publish_cc_define_type_attribute_high();
  void _publish_cc_define_type_attribute_length();
  void _publish_cc_define_type_attribute_ascending();

  void _publish_cc_constructor_with_no_value();
  void _publish_cc_constructor_with_value();
  void _publish_cc_copy_constructor();
  void _publish_cc_constructor_with_string();
  void _publish_cc_constructor_for_alias_init();
  void _publish_cc_constructor_with_aggregates();
  void _publish_cc_constructor_with_base_type();
};
#endif
