
#ifndef IIRBASE_SUBPROGRAM_DECLARATION_HH
#define IIRBASE_SUBPROGRAM_DECLARATION_HH

// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_SubprogramDeclaration.hh,v 1.2 1999/03/09 20:52:07 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIR_Declaration.hh"
#include "IIR_InterfaceList.hh"
#include "IIR_DeclarationList.hh"
#include "IIR_SequentialStatementList.hh"
#include "IIR_AttributeSpecificationList.hh"

class IIRBase_SubprogramDeclaration : public IIR_Declaration {

// @BeginAutoDocExternalProseDescription
// @EndAutoDocExternalProseDescription

public:

  IIR_Kind get_kind() {return IIR_SUBPROGRAM_DECLARATION;}
  IIR_Char *get_kind_text() {return "IIR_SubprogramDeclaration";}

  IIR_InterfaceList interface_declarations;
  IIR_DeclarationList subprogram_declarations;
  IIR_SequentialStatementList subprogram_body;
  IIR_AttributeSpecificationList attributes;


protected:
  
  IIRBase_SubprogramDeclaration();
  virtual ~IIRBase_SubprogramDeclaration() = 0;
    
private:
  

};

#endif
