
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
// 
// $Id: IIRBase_MonadicOperator.cc,v 1.2 1999/03/09 20:50:58 dmartin Exp $
// 
//---------------------------------------------------------------------------

#include "IIRBase_MonadicOperator.hh"
#include "savant.hh"

IIRBase_MonadicOperator::IIRBase_MonadicOperator() {
  set_implementation(NULL);
  set_operand(NULL);
}

IIRBase_MonadicOperator::~IIRBase_MonadicOperator() {}

void 
IIRBase_MonadicOperator::set_implementation(IIR_SubprogramDeclaration* implementation) {
  this->implementation = implementation;
}

IIR_SubprogramDeclaration*
IIRBase_MonadicOperator::get_implementation() {
  return implementation;
}

void
IIRBase_MonadicOperator::set_operand( IIR* operand) {
  this->operand = operand;
}

IIR*
IIRBase_MonadicOperator::get_operand() {
  return operand;
}
