/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: Node.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hbrinkm $ $Date: 2006/11/01 09:14:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

/*  Copyright 2005 Sun Microsystems, Inc. */

#ifndef INCLUDED_NODE_HXX
#define INCLUDED_NODE_HXX

#ifndef INCLUDED_QNAME_HXX
#include <odiapi/qname/QName.hxx>
#endif

#ifndef INCLUDED_PROPERTIES_HXX
#include <odiapi/props/Properties.hxx>
#endif

#include <memory>
#include <string>
#include <boost/shared_ptr.hpp>

namespace odiapi { namespace core {

    class WRITERFILTER_DLLPUBLIC Node
    {   
    public:
		typedef std::auto_ptr<Node> Pointer_t;
	
        /**
         */
        virtual ~Node();

        /** Get the id of a node instance

        @return the id
        */
        virtual writerfilter::QName_t getId() const = 0;

        /** The the properties of a node instance
        
        @return a handle to the property pool
        */
		virtual odiapi::props::PropertyPoolHandle_Pointer_t getProperties() const = 0;

        /** Get 
         */  
        virtual const std::string& getText() const = 0;

        /** Insert a sibling to the right.
        
            Transfer of ownership semantic.
        
            @param sibling
            sibling to insert. 

	        @precond sibling.get() != NULL && sibling->getParent() == NULL
	  
	        @postcond this->getNext == other->getFirstChild || this->getNext == other
        */
		virtual void insertSibling(Node::Pointer_t sibling) = 0;

        /** Append a child to this node.

            Transfer of ownership semantic.

            @param children
            child(ren) to append. 

	        @precond children.get() != NULL && children->getParent() == NULL

	        @postcond this->getLastChild() == children && children->getParent() == this
        */
		virtual void appendChildren(Node::Pointer_t children) = 0;

        /** Is there a previous?
         */
        virtual bool hasPrevious() const = 0;

        /** Get the previous Node.
	  
            @return the previous node or itself in case there 
            is no previous node
        */
        virtual const Node& getPrevious() const = 0;

        /** Is there a next node?
         */
        virtual bool hasNext() const = 0;

        /** Get the next node.
	  
	        @return the next node or itself in case there 
     	    is no previous node
        */
        virtual const Node& getNext() const = 0;

        /** Get the parent node.
            @return the parent of this node or a 
            NullObject in case there is no parent
        */
        virtual const Node& getParent() const = 0;

        /** 
         */
        virtual const Node& getFirstChild() const = 0;

        /** 
         */
        virtual const Node& getLastChild() const = 0;

        /** 
            @return the next sibling or NULL if
            there is none
        */
        virtual Node* getNextSibling() const = 0;

        /** 
            @return the previous sibling or NULL if there
            is none
        */
        virtual Node* getPrevSibling() const = 0;
    };

    /** Create a new text node
     */
	WRITERFILTER_DLLPUBLIC Node::Pointer_t createNode(
		writerfilter::QName_t id, 
		odiapi::props::PropertyPoolHandle_Pointer_t poolHandle, 
		const std::string& text);

} } // namespace core {  namespace odiapi {

#endif // INCLUDED_NODE_HXX

