/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: swwait.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/16 22:36:25 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sw.hxx"



#ifndef _SFXVIEWFRM_HXX //autogen wg. SfxViewFrame
#include <sfx2/viewfrm.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen wg. SfxDispatcher
#include <sfx2/dispatch.hxx>
#endif
#ifndef _WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _SWDOCSH_HXX //autogen wg. SwDocShell
#include <docsh.hxx>
#endif
#ifndef _SWWAIT_HXX
#include <swwait.hxx>
#endif


void SwDocShell::EnterWait( BOOL bLockDispatcher )
{
	SfxViewFrame *pFrame = SfxViewFrame::GetFirst( this, 0, FALSE );
	while ( pFrame )
	{
		pFrame->GetWindow().EnterWait();
		if ( bLockDispatcher )
			pFrame->GetDispatcher()->Lock( TRUE );
		pFrame = SfxViewFrame::GetNext( *pFrame, this, 0, FALSE );
	}
}

void SwDocShell::LeaveWait( BOOL bLockDispatcher )
{
	SfxViewFrame *pFrame = SfxViewFrame::GetFirst( this, 0, FALSE );
	while ( pFrame )
	{
		pFrame->GetWindow().LeaveWait();
		if ( bLockDispatcher )
			pFrame->GetDispatcher()->Lock( FALSE );
		pFrame = SfxViewFrame::GetNext( *pFrame, this, 0, FALSE );
	}
}

SwWait::SwWait( SwDocShell &rDocShell, BOOL bLockDispatcher ) :
	rDoc ( rDocShell ),
	bLock( bLockDispatcher )
{
	rDoc.EnterWait( bLock );
}

SwWait::~SwWait()
{
	rDoc.LeaveWait( bLock );
}


