/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: numpara.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 09:53:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _NUMPARA_HXX
#define _NUMPARA_HXX


#ifndef _SFXTABDLG_HXX //autogen
#include <sfx2/tabdlg.hxx>
#endif
#ifndef _SV_LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif
#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif


/* --- class SwParagraphNumTabPage ----------------------------------------
	Mit dieser TabPage werden Numerierungseinstellungen am Absatz bzw. der
	Absatzvorlage vorgenommen.

 ---------------------------------------------------------------------------*/
class SwParagraphNumTabPage : public SfxTabPage
{
    FixedText               aNumberStyleFT;
	ListBox					aNumberStyleLB;

    FixedLine               aNewStartFL;
	TriStateBox				aNewStartCB;
    TriStateBox             aNewStartNumberCB;
	NumericField			aNewStartNF;

    FixedLine               aCountParaFL;
	TriStateBox				aCountParaCB;
	TriStateBox				aRestartParaCountCB;
	FixedText				aRestartFT;
	NumericField			aRestartNF;

	BOOL					bModified : 1;
	BOOL					bCurNumrule : 1;

	DECL_LINK( NewStartHdl_Impl, CheckBox* );
	DECL_LINK( StyleHdl_Impl, ListBox* );
	DECL_LINK( LineCountHdl_Impl, CheckBox* );

protected:
		SwParagraphNumTabPage(Window* pParent, const SfxItemSet& rSet );

public:
		~SwParagraphNumTabPage();

	static SfxTabPage*	Create(	Window* pParent,
								const SfxItemSet& rSet );
	static USHORT*		GetRanges();

	virtual BOOL		FillItemSet( SfxItemSet& rSet );
	virtual void		Reset( const SfxItemSet& rSet );

	void				EnableNewStart();

	ListBox&			GetStyleBox() {return aNumberStyleLB;};

};


#endif

