/* handle.c generated by valac 0.40.8, the Vala compiler
 * generated from handle.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2016 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2016-2017 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <string.h>
#include <float.h>
#include <math.h>


#define TYPE_HANDLE (handle_get_type ())
#define HANDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HANDLE, Handle))
#define HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HANDLE, HandleClass))
#define IS_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HANDLE))
#define IS_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HANDLE))
#define HANDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HANDLE, HandleClass))

typedef struct _Handle Handle;
typedef struct _HandleClass HandleClass;
typedef struct _HandlePrivate HandlePrivate;
enum  {
	HANDLE_0_PROPERTY,
	HANDLE_NUM_PROPERTIES
};
static GParamSpec* handle_properties[HANDLE_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	HANDLE_MOVE_BEGIN_SIGNAL,
	HANDLE_MOVE_END_SIGNAL,
	HANDLE_NUM_SIGNALS
};
static guint handle_signals[HANDLE_NUM_SIGNALS] = {0};

struct _Handle {
	GtkEventBox parent_instance;
	HandlePrivate * priv;
};

struct _HandleClass {
	GtkEventBoxClass parent_class;
};

struct _HandlePrivate {
	gboolean m_move_begined;
	GdkRectangle m_workarea;
	GdkPoint m_press_pos;
};


static gpointer handle_parent_class = NULL;

GType handle_get_type (void) G_GNUC_CONST;
#define HANDLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_HANDLE, HandlePrivate))
Handle* handle_new (void);
Handle* handle_construct (GType object_type);
static void handle_real_realize (GtkWidget* base);
static gboolean handle_real_button_press_event (GtkWidget* base,
                                         GdkEventButton* event);
static gboolean handle_real_button_release_event (GtkWidget* base,
                                           GdkEventButton* event);
static gboolean handle_real_motion_notify_event (GtkWidget* base,
                                          GdkEventMotion* event);
static gboolean handle_real_draw (GtkWidget* base,
                           cairo_t* cr);
static void handle_finalize (GObject * obj);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


Handle*
handle_construct (GType object_type)
{
	Handle * self = NULL;
	GdkEventMask mask = 0;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (Handle*) g_object_new (object_type, "name", "IBusHandle", NULL);
	gtk_widget_set_size_request ((GtkWidget*) self, 6, -1);
	mask = ((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_BUTTON1_MOTION_MASK;
	gtk_widget_set_events ((GtkWidget*) self, (gint) mask);
	self->priv->m_move_begined = FALSE;
	_tmp0_ = gtk_css_provider_new ();
	css_provider = _tmp0_;
	{
		gtk_css_provider_load_from_data (css_provider, "#IBusHandle { background-color: gray }", (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = _error_;
		_tmp2_ = _tmp1_->message;
		g_warning ("handle.vala:53: Parse error in Handle: %s", _tmp2_);
		_g_error_free0 (_error_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (css_provider);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	context = _tmp4_;
	gtk_style_context_add_provider (context, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (context);
	_g_object_unref0 (css_provider);
	return self;
}


Handle*
handle_new (void)
{
	return handle_construct (TYPE_HANDLE);
}


static void
handle_real_realize (GtkWidget* base)
{
	Handle * self;
	self = (Handle*) base;
	GTK_WIDGET_CLASS (handle_parent_class)->realize ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_event_box_get_type (), GtkEventBox));
}


static gboolean
handle_real_button_press_event (GtkWidget* base,
                                GdkEventButton* event)
{
	Handle * self;
	gboolean result = FALSE;
	guint _tmp0_;
	GdkRectangle _tmp1_ = {0};
	GdkRectangle _tmp2_;
	gint x = 0;
	gint y = 0;
	GtkWindow* toplevel = NULL;
	GtkWidget* _tmp99_;
	GtkWindow* _tmp100_;
	GtkWindow* _tmp101_;
	gint _tmp102_ = 0;
	gint _tmp103_ = 0;
	gdouble _tmp104_;
	gint _tmp105_;
	gdouble _tmp106_;
	gint _tmp107_;
	self = (Handle*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->button;
	if (_tmp0_ != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	memset (&_tmp1_, 0, sizeof (GdkRectangle));
	_tmp1_.x = 0;
	_tmp1_.y = 0;
	_tmp1_.width = G_MAXINT;
	_tmp1_.height = G_MAXINT;
	self->priv->m_workarea = _tmp1_;
	_tmp2_ = self->priv->m_workarea;
	{
		gboolean _tmp3_ = FALSE;
		_tmp3_ = TRUE;
		while (TRUE) {
			GdkWindow* root = NULL;
			GdkWindow* _tmp4_;
			GdkWindow* _tmp5_;
			GdkAtom property = 0U;
			GdkAtom type = 0U;
			GdkAtom actual_type = 0U;
			gint format = 0;
			guchar* data = NULL;
			gint data_length1 = 0;
			gint _data_size_ = 0;
			gboolean _result_ = FALSE;
			GdkWindow* _tmp6_;
			GdkAtom _tmp7_;
			GdkAtom _tmp8_;
			GdkAtom _tmp9_ = 0U;
			gint _tmp10_ = 0;
			guint8* _tmp11_ = NULL;
			gint _tmp12_;
			gboolean _tmp13_;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			gboolean _tmp16_ = FALSE;
			gboolean _tmp17_;
			gint index = 0;
			guchar* _tmp22_;
			gint _tmp22__length1;
			guchar _tmp23_;
			guchar* _tmp24_;
			gint _tmp24__length1;
			guchar _tmp25_;
			guchar* _tmp26_;
			gint _tmp26__length1;
			guchar _tmp27_;
			guchar* _tmp28_;
			gint _tmp28__length1;
			guchar _tmp29_;
			GdkWindow* _tmp30_;
			GdkAtom _tmp31_;
			GdkAtom _tmp32_;
			GdkAtom _tmp33_ = 0U;
			gint _tmp34_ = 0;
			guint8* _tmp35_ = NULL;
			gint _tmp36_;
			gboolean _tmp37_;
			gboolean _tmp38_ = FALSE;
			gboolean _tmp39_ = FALSE;
			gboolean _tmp40_ = FALSE;
			gboolean _tmp41_;
			gint i = 0;
			gint _tmp47_;
			guchar* _tmp48_;
			gint _tmp48__length1;
			gint _tmp49_;
			guchar _tmp50_;
			guchar* _tmp51_;
			gint _tmp51__length1;
			gint _tmp52_;
			guchar _tmp53_;
			guchar* _tmp54_;
			gint _tmp54__length1;
			gint _tmp55_;
			guchar _tmp56_;
			guchar* _tmp57_;
			gint _tmp57__length1;
			gint _tmp58_;
			guchar _tmp59_;
			gint _tmp60_;
			guchar* _tmp61_;
			gint _tmp61__length1;
			gint _tmp62_;
			guchar _tmp63_;
			guchar* _tmp64_;
			gint _tmp64__length1;
			gint _tmp65_;
			guchar _tmp66_;
			guchar* _tmp67_;
			gint _tmp67__length1;
			gint _tmp68_;
			guchar _tmp69_;
			guchar* _tmp70_;
			gint _tmp70__length1;
			gint _tmp71_;
			guchar _tmp72_;
			gint _tmp73_;
			guchar* _tmp74_;
			gint _tmp74__length1;
			gint _tmp75_;
			guchar _tmp76_;
			guchar* _tmp77_;
			gint _tmp77__length1;
			gint _tmp78_;
			guchar _tmp79_;
			guchar* _tmp80_;
			gint _tmp80__length1;
			gint _tmp81_;
			guchar _tmp82_;
			guchar* _tmp83_;
			gint _tmp83__length1;
			gint _tmp84_;
			guchar _tmp85_;
			gint _tmp86_;
			guchar* _tmp87_;
			gint _tmp87__length1;
			gint _tmp88_;
			guchar _tmp89_;
			guchar* _tmp90_;
			gint _tmp90__length1;
			gint _tmp91_;
			guchar _tmp92_;
			guchar* _tmp93_;
			gint _tmp93__length1;
			gint _tmp94_;
			guchar _tmp95_;
			guchar* _tmp96_;
			gint _tmp96__length1;
			gint _tmp97_;
			guchar _tmp98_;
			if (!_tmp3_) {
				if (!FALSE) {
					break;
				}
			}
			_tmp3_ = FALSE;
			_tmp4_ = gdk_get_default_root_window ();
			_tmp5_ = _g_object_ref0 (_tmp4_);
			root = _tmp5_;
			property = gdk_atom_intern ("_NET_CURRENT_DESKTOP", FALSE);
			type = gdk_atom_intern ("CARDINAL", FALSE);
			_tmp6_ = root;
			_tmp7_ = property;
			_tmp8_ = type;
			_tmp13_ = gdk_property_get (_tmp6_, _tmp7_, _tmp8_, (gulong) 0, (gulong) G_MAXLONG, 0, &_tmp9_, &_tmp10_, &_tmp12_, &_tmp11_);
			actual_type = _tmp9_;
			format = _tmp10_;
			data = (g_free (data), NULL);
			data = _tmp11_;
			data_length1 = _tmp12_;
			_data_size_ = data_length1;
			_result_ = _tmp13_;
			_tmp17_ = _result_;
			if (!_tmp17_) {
				_tmp16_ = TRUE;
			} else {
				GdkAtom _tmp18_;
				GdkAtom _tmp19_;
				_tmp18_ = actual_type;
				_tmp19_ = type;
				_tmp16_ = _tmp18_ != _tmp19_;
			}
			if (_tmp16_) {
				_tmp15_ = TRUE;
			} else {
				gint _tmp20_;
				_tmp20_ = format;
				_tmp15_ = _tmp20_ != 32;
			}
			if (_tmp15_) {
				_tmp14_ = TRUE;
			} else {
				guchar* _tmp21_;
				gint _tmp21__length1;
				_tmp21_ = data;
				_tmp21__length1 = data_length1;
				_tmp14_ = _tmp21__length1 != 4;
			}
			if (_tmp14_) {
				data = (g_free (data), NULL);
				_g_object_unref0 (root);
				break;
			}
			_tmp22_ = data;
			_tmp22__length1 = data_length1;
			_tmp23_ = _tmp22_[0];
			_tmp24_ = data;
			_tmp24__length1 = data_length1;
			_tmp25_ = _tmp24_[1];
			_tmp26_ = data;
			_tmp26__length1 = data_length1;
			_tmp27_ = _tmp26_[2];
			_tmp28_ = data;
			_tmp28__length1 = data_length1;
			_tmp29_ = _tmp28_[3];
			index = (gint) (((_tmp23_ | (_tmp25_ << 8)) | (_tmp27_ << 16)) | (_tmp29_ << 24));
			property = gdk_atom_intern ("_NET_WORKAREA", FALSE);
			type = gdk_atom_intern ("CARDINAL", FALSE);
			_tmp30_ = root;
			_tmp31_ = property;
			_tmp32_ = type;
			_tmp37_ = gdk_property_get (_tmp30_, _tmp31_, _tmp32_, (gulong) 0, (gulong) G_MAXLONG, 0, &_tmp33_, &_tmp34_, &_tmp36_, &_tmp35_);
			actual_type = _tmp33_;
			format = _tmp34_;
			data = (g_free (data), NULL);
			data = _tmp35_;
			data_length1 = _tmp36_;
			_data_size_ = data_length1;
			_result_ = _tmp37_;
			_tmp41_ = _result_;
			if (!_tmp41_) {
				_tmp40_ = TRUE;
			} else {
				GdkAtom _tmp42_;
				GdkAtom _tmp43_;
				_tmp42_ = actual_type;
				_tmp43_ = type;
				_tmp40_ = _tmp42_ != _tmp43_;
			}
			if (_tmp40_) {
				_tmp39_ = TRUE;
			} else {
				gint _tmp44_;
				_tmp44_ = format;
				_tmp39_ = _tmp44_ != 32;
			}
			if (_tmp39_) {
				_tmp38_ = TRUE;
			} else {
				guchar* _tmp45_;
				gint _tmp45__length1;
				gint _tmp46_;
				_tmp45_ = data;
				_tmp45__length1 = data_length1;
				_tmp46_ = index;
				_tmp38_ = _tmp45__length1 < ((_tmp46_ + 1) * 16);
			}
			if (_tmp38_) {
				data = (g_free (data), NULL);
				_g_object_unref0 (root);
				break;
			}
			_tmp47_ = index;
			i = (_tmp47_ * 4) * 4;
			_tmp48_ = data;
			_tmp48__length1 = data_length1;
			_tmp49_ = i;
			_tmp50_ = _tmp48_[_tmp49_];
			_tmp51_ = data;
			_tmp51__length1 = data_length1;
			_tmp52_ = i;
			_tmp53_ = _tmp51_[_tmp52_ + 1];
			_tmp54_ = data;
			_tmp54__length1 = data_length1;
			_tmp55_ = i;
			_tmp56_ = _tmp54_[_tmp55_ + 2];
			_tmp57_ = data;
			_tmp57__length1 = data_length1;
			_tmp58_ = i;
			_tmp59_ = _tmp57_[_tmp58_ + 3];
			self->priv->m_workarea.x = (gint) (((_tmp50_ | (_tmp53_ << 8)) | (_tmp56_ << 16)) | (_tmp59_ << 24));
			_tmp60_ = i;
			i = _tmp60_ + 4;
			_tmp61_ = data;
			_tmp61__length1 = data_length1;
			_tmp62_ = i;
			_tmp63_ = _tmp61_[_tmp62_];
			_tmp64_ = data;
			_tmp64__length1 = data_length1;
			_tmp65_ = i;
			_tmp66_ = _tmp64_[_tmp65_ + 1];
			_tmp67_ = data;
			_tmp67__length1 = data_length1;
			_tmp68_ = i;
			_tmp69_ = _tmp67_[_tmp68_ + 2];
			_tmp70_ = data;
			_tmp70__length1 = data_length1;
			_tmp71_ = i;
			_tmp72_ = _tmp70_[_tmp71_ + 3];
			self->priv->m_workarea.y = (gint) (((_tmp63_ | (_tmp66_ << 8)) | (_tmp69_ << 16)) | (_tmp72_ << 24));
			_tmp73_ = i;
			i = _tmp73_ + 4;
			_tmp74_ = data;
			_tmp74__length1 = data_length1;
			_tmp75_ = i;
			_tmp76_ = _tmp74_[_tmp75_];
			_tmp77_ = data;
			_tmp77__length1 = data_length1;
			_tmp78_ = i;
			_tmp79_ = _tmp77_[_tmp78_ + 1];
			_tmp80_ = data;
			_tmp80__length1 = data_length1;
			_tmp81_ = i;
			_tmp82_ = _tmp80_[_tmp81_ + 2];
			_tmp83_ = data;
			_tmp83__length1 = data_length1;
			_tmp84_ = i;
			_tmp85_ = _tmp83_[_tmp84_ + 3];
			self->priv->m_workarea.width = (gint) (((_tmp76_ | (_tmp79_ << 8)) | (_tmp82_ << 16)) | (_tmp85_ << 24));
			_tmp86_ = i;
			i = _tmp86_ + 4;
			_tmp87_ = data;
			_tmp87__length1 = data_length1;
			_tmp88_ = i;
			_tmp89_ = _tmp87_[_tmp88_];
			_tmp90_ = data;
			_tmp90__length1 = data_length1;
			_tmp91_ = i;
			_tmp92_ = _tmp90_[_tmp91_ + 1];
			_tmp93_ = data;
			_tmp93__length1 = data_length1;
			_tmp94_ = i;
			_tmp95_ = _tmp93_[_tmp94_ + 2];
			_tmp96_ = data;
			_tmp96__length1 = data_length1;
			_tmp97_ = i;
			_tmp98_ = _tmp96_[_tmp97_ + 3];
			self->priv->m_workarea.height = (gint) (((_tmp89_ | (_tmp92_ << 8)) | (_tmp95_ << 16)) | (_tmp98_ << 24));
			data = (g_free (data), NULL);
			_g_object_unref0 (root);
		}
	}
	self->priv->m_move_begined = TRUE;
	_tmp99_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp100_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, gtk_window_get_type (), GtkWindow));
	toplevel = _tmp100_;
	_tmp101_ = toplevel;
	gtk_window_get_position (_tmp101_, &_tmp102_, &_tmp103_);
	x = _tmp102_;
	y = _tmp103_;
	_tmp104_ = event->x_root;
	_tmp105_ = x;
	self->priv->m_press_pos.x = ((gint) _tmp104_) - _tmp105_;
	_tmp106_ = event->y_root;
	_tmp107_ = y;
	self->priv->m_press_pos.y = ((gint) _tmp106_) - _tmp107_;
	g_signal_emit (self, handle_signals[HANDLE_MOVE_BEGIN_SIGNAL], 0);
	result = TRUE;
	_g_object_unref0 (toplevel);
	return result;
}


static gboolean
handle_real_button_release_event (GtkWidget* base,
                                  GdkEventButton* event)
{
	Handle * self;
	gboolean result = FALSE;
	guint _tmp0_;
	GdkWindow* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkCursor* _tmp3_;
	GdkCursor* _tmp4_;
	self = (Handle*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event->button;
	if (_tmp0_ != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	self->priv->m_move_begined = FALSE;
	self->priv->m_press_pos.x = 0;
	self->priv->m_press_pos.y = 0;
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
	_tmp2_ = gdk_display_get_default ();
	_tmp3_ = gdk_cursor_new_for_display (_tmp2_, GDK_FLEUR);
	_tmp4_ = _tmp3_;
	gdk_window_set_cursor (_tmp1_, _tmp4_);
	_g_object_unref0 (_tmp4_);
	g_signal_emit (self, handle_signals[HANDLE_MOVE_END_SIGNAL], 0);
	result = TRUE;
	return result;
}


static gboolean
handle_real_motion_notify_event (GtkWidget* base,
                                 GdkEventMotion* event)
{
	Handle * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	GtkWindow* toplevel = NULL;
	GtkWidget* _tmp1_;
	GtkWindow* _tmp2_;
	gint x = 0;
	gdouble _tmp3_;
	GdkPoint _tmp4_;
	gint _tmp5_;
	gint y = 0;
	gdouble _tmp6_;
	GdkPoint _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_;
	GdkRectangle _tmp11_;
	gint _tmp12_;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_;
	GdkRectangle _tmp20_;
	gint _tmp21_;
	gint w = 0;
	gint h = 0;
	GtkWindow* _tmp27_;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	gint _tmp31_;
	gint _tmp32_;
	GdkRectangle _tmp33_;
	gint _tmp34_;
	GdkRectangle _tmp35_;
	gint _tmp36_;
	gboolean _tmp48_ = FALSE;
	gint _tmp49_;
	gint _tmp50_;
	GdkRectangle _tmp51_;
	gint _tmp52_;
	GdkRectangle _tmp53_;
	gint _tmp54_;
	GtkWindow* _tmp66_;
	gint _tmp67_;
	gint _tmp68_;
	self = (Handle*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->m_move_begined;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	toplevel = _tmp2_;
	_tmp3_ = event->x_root;
	_tmp4_ = self->priv->m_press_pos;
	_tmp5_ = _tmp4_.x;
	x = (gint) (_tmp3_ - _tmp5_);
	_tmp6_ = event->y_root;
	_tmp7_ = self->priv->m_press_pos;
	_tmp8_ = _tmp7_.y;
	y = (gint) (_tmp6_ - _tmp8_);
	_tmp10_ = x;
	_tmp11_ = self->priv->m_workarea;
	_tmp12_ = _tmp11_.x;
	if (_tmp10_ < _tmp12_) {
		gint _tmp13_;
		GdkRectangle _tmp14_;
		gint _tmp15_;
		_tmp13_ = x;
		_tmp14_ = self->priv->m_workarea;
		_tmp15_ = _tmp14_.x;
		_tmp9_ = _tmp13_ > (_tmp15_ - 16);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GdkRectangle _tmp16_;
		gint _tmp17_;
		_tmp16_ = self->priv->m_workarea;
		_tmp17_ = _tmp16_.x;
		x = _tmp17_;
	}
	_tmp19_ = y;
	_tmp20_ = self->priv->m_workarea;
	_tmp21_ = _tmp20_.y;
	if (_tmp19_ < _tmp21_) {
		gint _tmp22_;
		GdkRectangle _tmp23_;
		gint _tmp24_;
		_tmp22_ = y;
		_tmp23_ = self->priv->m_workarea;
		_tmp24_ = _tmp23_.y;
		_tmp18_ = _tmp22_ > (_tmp24_ - 16);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		GdkRectangle _tmp25_;
		gint _tmp26_;
		_tmp25_ = self->priv->m_workarea;
		_tmp26_ = _tmp25_.y;
		y = _tmp26_;
	}
	_tmp27_ = toplevel;
	gtk_window_get_size (_tmp27_, &_tmp28_, &_tmp29_);
	w = _tmp28_;
	h = _tmp29_;
	_tmp31_ = x;
	_tmp32_ = w;
	_tmp33_ = self->priv->m_workarea;
	_tmp34_ = _tmp33_.x;
	_tmp35_ = self->priv->m_workarea;
	_tmp36_ = _tmp35_.width;
	if ((_tmp31_ + _tmp32_) > (_tmp34_ + _tmp36_)) {
		gint _tmp37_;
		gint _tmp38_;
		GdkRectangle _tmp39_;
		gint _tmp40_;
		GdkRectangle _tmp41_;
		gint _tmp42_;
		_tmp37_ = x;
		_tmp38_ = w;
		_tmp39_ = self->priv->m_workarea;
		_tmp40_ = _tmp39_.x;
		_tmp41_ = self->priv->m_workarea;
		_tmp42_ = _tmp41_.width;
		_tmp30_ = (_tmp37_ + _tmp38_) < ((_tmp40_ + _tmp42_) + 16);
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		GdkRectangle _tmp43_;
		gint _tmp44_;
		GdkRectangle _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		_tmp43_ = self->priv->m_workarea;
		_tmp44_ = _tmp43_.x;
		_tmp45_ = self->priv->m_workarea;
		_tmp46_ = _tmp45_.width;
		_tmp47_ = w;
		x = (_tmp44_ + _tmp46_) - _tmp47_;
	}
	_tmp49_ = y;
	_tmp50_ = h;
	_tmp51_ = self->priv->m_workarea;
	_tmp52_ = _tmp51_.y;
	_tmp53_ = self->priv->m_workarea;
	_tmp54_ = _tmp53_.height;
	if ((_tmp49_ + _tmp50_) > (_tmp52_ + _tmp54_)) {
		gint _tmp55_;
		gint _tmp56_;
		GdkRectangle _tmp57_;
		gint _tmp58_;
		GdkRectangle _tmp59_;
		gint _tmp60_;
		_tmp55_ = y;
		_tmp56_ = h;
		_tmp57_ = self->priv->m_workarea;
		_tmp58_ = _tmp57_.y;
		_tmp59_ = self->priv->m_workarea;
		_tmp60_ = _tmp59_.height;
		_tmp48_ = (_tmp55_ + _tmp56_) < ((_tmp58_ + _tmp60_) + 16);
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		GdkRectangle _tmp61_;
		gint _tmp62_;
		GdkRectangle _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		_tmp61_ = self->priv->m_workarea;
		_tmp62_ = _tmp61_.y;
		_tmp63_ = self->priv->m_workarea;
		_tmp64_ = _tmp63_.height;
		_tmp65_ = w;
		y = (_tmp62_ + _tmp64_) - _tmp65_;
	}
	_tmp66_ = toplevel;
	_tmp67_ = x;
	_tmp68_ = y;
	gtk_window_move (_tmp66_, _tmp67_, _tmp68_);
	result = TRUE;
	_g_object_unref0 (toplevel);
	return result;
}


static gboolean
handle_real_draw (GtkWidget* base,
                  cairo_t* cr)
{
	Handle * self;
	gboolean result = FALSE;
	GdkWindow* _tmp0_;
	self = (Handle*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) self);
	if (gtk_cairo_should_draw_window (cr, _tmp0_)) {
		GtkStyleContext* context = NULL;
		GtkStyleContext* _tmp1_;
		GtkStyleContext* _tmp2_;
		GtkAllocation allocation = {0};
		GtkAllocation _tmp3_ = {0};
		GtkStyleContext* _tmp4_;
		GtkAllocation _tmp5_;
		gint _tmp6_;
		GtkAllocation _tmp7_;
		gint _tmp8_;
		GtkAllocation _tmp9_;
		gint _tmp10_;
		GtkAllocation _tmp11_;
		gint _tmp12_;
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		context = _tmp2_;
		gtk_widget_get_allocation ((GtkWidget*) self, &_tmp3_);
		allocation = _tmp3_;
		_tmp4_ = context;
		_tmp5_ = allocation;
		_tmp6_ = _tmp5_.x;
		_tmp7_ = allocation;
		_tmp8_ = _tmp7_.y;
		_tmp9_ = allocation;
		_tmp10_ = _tmp9_.height;
		_tmp11_ = allocation;
		_tmp12_ = _tmp11_.width;
		gtk_render_handle (_tmp4_, cr, (gdouble) _tmp6_, (gdouble) (_tmp8_ + ((_tmp10_ - 40) / 2)), (gdouble) _tmp12_, 40.0);
		_g_object_unref0 (context);
	}
	result = FALSE;
	return result;
}


static void
handle_class_init (HandleClass * klass)
{
	handle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (HandlePrivate));
	((GtkWidgetClass *) klass)->realize = (void (*) (GtkWidget *)) handle_real_realize;
	((GtkWidgetClass *) klass)->button_press_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) handle_real_button_press_event;
	((GtkWidgetClass *) klass)->button_release_event = (gboolean (*) (GtkWidget *, GdkEventButton*)) handle_real_button_release_event;
	((GtkWidgetClass *) klass)->motion_notify_event = (gboolean (*) (GtkWidget *, GdkEventMotion*)) handle_real_motion_notify_event;
	((GtkWidgetClass *) klass)->draw = (gboolean (*) (GtkWidget *, cairo_t*)) handle_real_draw;
	G_OBJECT_CLASS (klass)->finalize = handle_finalize;
	handle_signals[HANDLE_MOVE_BEGIN_SIGNAL] = g_signal_new ("move-begin", TYPE_HANDLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	handle_signals[HANDLE_MOVE_END_SIGNAL] = g_signal_new ("move-end", TYPE_HANDLE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
handle_instance_init (Handle * self)
{
	self->priv = HANDLE_GET_PRIVATE (self);
}


static void
handle_finalize (GObject * obj)
{
	Handle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HANDLE, Handle);
	G_OBJECT_CLASS (handle_parent_class)->finalize (obj);
}


GType
handle_get_type (void)
{
	static volatile gsize handle_type_id__volatile = 0;
	if (g_once_init_enter (&handle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HandleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) handle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Handle), 0, (GInstanceInitFunc) handle_instance_init, NULL };
		GType handle_type_id;
		handle_type_id = g_type_register_static (gtk_event_box_get_type (), "Handle", &g_define_type_info, 0);
		g_once_init_leave (&handle_type_id__volatile, handle_type_id);
	}
	return handle_type_id__volatile;
}



