# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

# Used as the FxA toolbar menu item value when user has not
# finished setting up an account.
account-finish-account-setup = Tik'is Runuk'ulem K'ak'a' Rub'i' Taqoya'l

# Used as the FxA toolbar menu item title when the user
# needs to reconnect their account.
account-disconnected2 = Chupun rub'i' taqoya'l

# Menu item that sends a tab to all synced devices.
account-send-to-all-devices = Titaq pa Ronojel taq Okisaxel

# Menu item that links to the Firefox Accounts settings for connected devices.
account-manage-devices = Kenuk'samajïx taq Okisaxel…

## Variables:
##   $email (String): = Email address of user's Firefox Account.

account-reconnect = Tokisäx chik { $email }
account-verify = Tinik'öx { $email }

## Displayed in the Send Tab/Page/Link to Device context menu when right clicking a tab, a page or a link.

account-send-to-all-devices-titlecase = Titaq pa Ronojel taq Okisaxel
account-manage-devices-titlecase = Kenuk'samajïx taq Okisaxel…

## Displayed in the Send Tabs context menu when right clicking a tab, a page or a link
## and the account has only 1 device connected.

# Redirects to a marketing page.
account-send-tab-to-device-singledevice-status = Majun Okisaxel Okisan

# Redirects to a marketing page.
account-send-tab-to-device-singledevice-learnmore = Tetamäx chi rij ri Kitaqik taq Ruwi'…

# Redirects to an FxAccounts page that tells to you to connect another device.
account-send-tab-to-device-connectdevice = Tokisäx Jun Chik Okisaxel…

## Displayed in the Send Tabs context menu when right clicking a tab, a page or a link
## and the Sync account is unverified. Redirects to the Sync preferences page.

account-send-tab-to-device-verify-status = Man jikib'an ta ri rub'i' taqoya'l
account-send-tab-to-device-verify = Tajikib'a' ri Rub'i' Ataqoya'l…

## These strings are used in a notification shown when a new device joins the Firefox account.

# The title shown in a notification when either this device or another device
# has connected to, or disconnected from, a Firefox account.
account-connection-title = { -fxaccount-brand-name(capitalization: "title") }

# Variables:
#   $deviceName (String): the name of the new device
account-connection-connected-with = Re kematz'ib' okinäq rik'in { $deviceName } wakami.

# Used when the name of the new device is not known.
account-connection-connected-with-noname = Re kematz'ib' re' okinäq rik'in jun k'ak'a' okisaxel wakami.

# Used in a notification shown after a Firefox account is connected to the current device.
account-connection-connected = Ütz xatikirisaj molojri'ïl

# Used in a notification shown after the Firefox account was disconnected remotely.
account-connection-disconnected = Xchup re kematz'ib' re'.

## These strings are used in a notification shown when we're opening
## a single tab another device sent us to display.
## The body for this notification is the URL of the received tab.

account-single-tab-arriving-title = Ruwi' k'ulun
# Variables:
#   $deviceName (String): the device name.
account-single-tab-arriving-from-device-title = Ruwi' { $deviceName }

# Used when a tab from a remote device arrives but the URL must be truncated.
# Should display the URL with an indication that it's been truncated.
# Variables:
#   $url (String): the portion of the URL that remains after truncation.
account-single-tab-arriving-truncated-url = { $url }…

## These strings are used in a notification shown when we're opening
## multiple tabs another device or devices sent us to display.
## Variables:
##   $tabCount (Number): the number of tabs received

account-multiple-tabs-arriving-title = Taq Ruwi' ek'ulun

# Variables:
#   $deviceName (String): the device name.
account-multiple-tabs-arriving-from-single-device =
    { $tabCount ->
        [one] { $tabCount } ruwi' petenäq pa { $deviceName }
       *[other] { $tabCount } taq ruwi' epetenäq pa { $deviceName }
    }
account-multiple-tabs-arriving-from-multiple-devices =
    { $tabCount ->
        [one] { $tabCount } ruwi' petenäq pan okinäq taq okisaxel
       *[other] { $tabCount } taq ruwi' epetenäq pan okinäq taq okisaxel
    }
# This version is used when we don't know any device names.
account-multiple-tabs-arriving-from-unknown-device =
    { $tabCount ->
        [one] { $tabCount } ruwi' petenäq
       *[other] { $tabCount } taq ruwi' epetenäq
    }
