% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lrm.fit.bare.r
\name{lrm.fit.bare}
\alias{lrm.fit.bare}
\title{lrm.fit.bare}
\usage{
lrm.fit.bare(x, y, maxit = 12, eps = 0.025, tol = 1e-07)
}
\arguments{
\item{x}{a vector of matrix of covariate values}

\item{y}{a numeric or factor vector representing the dependent variable}

\item{maxit}{maximum number of iteractions}

\item{eps}{stopping criterion (change in -2 log likelihood)}

\item{tol}{matrix inversion tolerance for singularities}
}
\value{
a list with elements \code{coefficients}, \code{var}, \code{fail}, \code{freq}, \code{deviance}
}
\description{
Bare Bones Logistic Regression Fit
}
\details{
This is a stripped down version of the \code{lrm.fit()} function that computes only the regression coefficients, variance-covariance-matrix, and log likelihood (for null and fitted model) and does not compute any model fit indexes etc.  This is for speed in simulations or with bootstrapping.  Missing data are not allowed.  The function handles binary and ordinal logistic regression (proportional odds model).
}
\author{
Frank Harrell
}
