% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{igraph-es-indexing2}
\alias{igraph-es-indexing2}
\alias{[[.igraph.es}
\title{Select edges and show their metadata}
\usage{
\method{[[}{igraph.es}(x, ...)
}
\arguments{
\item{x}{An edge sequence.}

\item{...}{Additional arguments, passed to \code{[}.}
}
\value{
Another edge sequence, with metadata printing turned on.
See details below.
}
\description{
The double bracket operator can be used on edge sequences, to print
the meta-data (edge attributes) of the edges in the sequence.
}
\details{
Technically, when used with edge sequences, the double bracket
operator does exactly the same as the single bracket operator,
but the resulting edge sequence is printed differently: all
attributes of the edges in the sequence are printed as well.

See \code{\link{[.igraph.es}} for more about indexing edge sequences.
}
\examples{
g <- make_(ring(10),
  with_vertex_(name = LETTERS[1:10]),
  with_edge_(weight = 1:10, color = "green"))
E(g)
E(g)[[]]
E(g)[[.inc('A')]]
}
\seealso{
Other vertex and edge sequences: 
\code{\link{E}()},
\code{\link{V}()},
\code{\link{igraph-es-attributes}},
\code{\link{igraph-es-indexing}},
\code{\link{igraph-vs-attributes}},
\code{\link{igraph-vs-indexing2}},
\code{\link{igraph-vs-indexing}},
\code{\link{print.igraph.es}()},
\code{\link{print.igraph.vs}()}

Other vertex and edge sequence operations: 
\code{\link{c.igraph.es}()},
\code{\link{c.igraph.vs}()},
\code{\link{difference.igraph.es}()},
\code{\link{difference.igraph.vs}()},
\code{\link{igraph-es-indexing}},
\code{\link{igraph-vs-indexing2}},
\code{\link{igraph-vs-indexing}},
\code{\link{intersection.igraph.es}()},
\code{\link{intersection.igraph.vs}()},
\code{\link{rev.igraph.es}()},
\code{\link{rev.igraph.vs}()},
\code{\link{union.igraph.es}()},
\code{\link{union.igraph.vs}()},
\code{\link{unique.igraph.es}()},
\code{\link{unique.igraph.vs}()}
}
\concept{vertex and edge sequence operations}
\concept{vertex and edge sequences}
