% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/windowAnalysis.R
\name{windowAnalysis}
\alias{windowAnalysis}
\title{windowAnalysis Returns a vector of integers representing the counts of
reads in a moving window.}
\usage{
windowAnalysis(reads, strand = "*", windowSize = stepSize,
  stepSize = windowSize, chrom = NULL, limitPCRDups = FALSE, ...)
}
\arguments{
\item{reads}{GenomicRanges object representing the position of reads
mapping in the genome.}

\item{strand}{Takes values of "+", "-", or "*".  "*" denotes collapsing
reads on both strands.  Default: "*".}

\item{windowSize}{Size of the moving window. Either windowSize or
stepSize must be specified.}

\item{stepSize}{The number of bp moved with each step.}

\item{chrom}{Chromosome for which to return data.
Default: returns all avaliable data.}

\item{limitPCRDups}{Counts only one read mapping to each start site.
NOTE: If set to TRUE, assumes that all reads are the same length
(don't use for paired-end data).  Default: FALSE.}

\item{...}{Extra argument passed to mclapply}
}
\value{
Returns a list object, each element of which represents a
chromosome.
}
\description{
Supports parallel processing using mclapply in the 'parallel' package.
To change the number of processors, set the option 'mc.cores'.
}
\examples{
S0mR1 <- as(readGAlignments(system.file("extdata", "S0mR1.bam",
     package="groHMM")), "GRanges")
## Not run:
# Fp <- windowAnalysis(S0mR1, strand="+", windowSize=50)
}
\author{
Charles G. Danko and Minho Chae
}

