// Copyright 2019, Collabora, Ltd.
// SPDX-License-Identifier: BSL-1.0
/*!
 * @file
 * @brief  Header with just documentation.
 * @author Jakob Bornecrantz <jakob@collabora.com>
 * @ingroup xrt_iface
 */

#pragma once

/*!
 * @defgroup xrt Monado(XRT)
 *
 * @brief Monado XR runtime project.
 */

/*!
 * @defgroup inc Includes
 * @ingroup xrt
 *
 * @brief Include and interface headers.
 */

/*!
 * @defgroup xrt_iface XRT interfaces
 * @ingroup inc
 *
 * @brief The main interface shared between the different components of Monado.
 */

/*!
 * @defgroup drv Drivers
 * @ingroup xrt
 *
 * @brief Native and wrapper drivers in Monado.
 */

/*!
 * @dir include/xrt
 * @ingroup inc
 *
 * @brief @ref xrt_iface includes.
 */

/*!
 * @dir state_trackers
 * @ingroup xrt
 *
 * @brief State trackers.
 */

/*!
 * @dir state_trackers/oxr
 * @ingroup oxr
 *
 * @brief @ref oxr files.
 */

/*!
 * @dir drivers
 * @ingroup xrt
 *
 * @brief @ref drv files.
 */
