/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* Universal Asynchronous Receiver/Transmitter (UART) */

/*
 * For most of the comments, infos, ... see:
 * TI AM1808/AM1810 ARM Microprocessor - Technical Reference Manual
 * (SPRUH82A - December 2011), Chapter 31, pages 1463...
 */

#define CONFIG_CONSOLE		1

#define DEBUG_CONTROL_FLOW	0

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

struct {
	uint32_t reg[0x1000 >> 2];
} NAME;

#endif /* STATE */
#ifdef BEHAVIOR

static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val)
{
	uint8_t c;

	addr &= 0xfff;

	if (DEBUG_CONTROL_FLOW) {
		fprintf(stderr, "%s: addr=0x%08x, bs=0x%x, val=0x%08x\n",
				__FUNCTION__, addr, bs, val);
	}

	switch (addr) {
	case 0x000:
		/* Transmitter Holding Register */
		c = (val >> 0) & 0xff;

#if CONFIG_CONSOLE
		fprintf(stderr, "%c", c);
#endif
#if DEBUG_CONTROL_FLOW
		fprintf(stderr, "UART1: Sending '");
		switch (c) {
		case '\t': fprintf(stderr, "\\t"); break;
		case '\n': fprintf(stderr, "\\n"); break;
		case '\r': fprintf(stderr, "\\r"); break;
		default:
			if (' ' <= c && c < 128) {
				fprintf(stderr, "%c", c);
			} else {
				fprintf(stderr, "0x%02x", (uint8_t) c);
			}
			break;
		}
		fprintf(stderr, "'\n");
#endif
		break;
	case 0x004:
		/* Interrupt Enable Register */
		goto todo;
		break;
	case 0x008:
		/* FIFO Control Register */
		goto todo;
		break;
	case 0x00c:
		/* Line Control Register */
		goto todo;
		break;
	case 0x010:
		/* Modem Control Register */
		goto todo;
		break;
	case 0x014:
		/* Line Status Register */
		goto todo;
		break;
	case 0x018:
		/* Modem Status Register */
		goto todo;
		break;
	/* ... */
	case 0x030:
		/* Power and Emulation Management Register */
		goto todo;
		break;
	/* ... */
	default:
	todo:	;
		fprintf(stderr, "WARNING: %s: addr=0x%08x\n",
				__FUNCTION__, addr);

		cpssp->NAME.reg[addr >> 2] = val;
		break;
	}
}

static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	addr &= 0xfff;

	switch (addr) {
	case 0x000:
		/* Receiver Buffer Register */
		goto todo;
		break;
	case 0x004:
		/* Interrupt Enable Register */
		goto todo;
		break;
	case 0x008:
		/* Interrupt Identification Register */
		goto todo;
		break;
	case 0x00c:
		/* Line Control Register */
		goto todo;
		break;
	case 0x010:
		/* Modem Control Register */
		goto todo;
		break;
	case 0x014:
		/* Line Status Register */
		*valp = 32;
		goto warn;
		break;
	case 0x018:
		/* Modem Status Register */
		goto todo;
		break;
	/* ... */
	case 0x030:
		/* Power and Emulation Management Register */
		*valp = 0;
		goto warn;
		break;
	/* ... */
	default:
	todo:	;
		*valp = cpssp->NAME.reg[addr >> 2];
	warn:	;
		fprintf(stderr, "WARNING: %s: addr=0x%08x\n",
				__FUNCTION__, addr);
		break;
	}

	if (DEBUG_CONTROL_FLOW) {
		fprintf(stderr, "%s: addr=0x%08x, bs=0x%x, *valp=0x%08x\n",
				__FUNCTION__, addr, bs, *valp);
	}
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef DEBUG_CONTROL_FLOW
