/*********************                                                        */
/*! \file module_template.h
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Contains code for handling command-line options.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.h file.
 **/

#include "cvc4_private.h"

#ifndef __CVC4__OPTIONS__DATATYPES_H
#define __CVC4__OPTIONS__DATATYPES_H

#include "options/options.h"

#include "options/datatypes_modes.h"


#define CVC4_OPTIONS__DATATYPES__FOR_OPTION_HOLDER \
  cdtBisimilar__option_t::type cdtBisimilar;\
  bool cdtBisimilar__setByUser__; \
  dtBinarySplit__option_t::type dtBinarySplit;\
  bool dtBinarySplit__setByUser__; \
  dtBlastSplits__option_t::type dtBlastSplits;\
  bool dtBlastSplits__setByUser__; \
  dtCyclic__option_t::type dtCyclic;\
  bool dtCyclic__setByUser__; \
  dtForceAssignment__option_t::type dtForceAssignment;\
  bool dtForceAssignment__setByUser__; \
  dtInferAsLemmas__option_t::type dtInferAsLemmas;\
  bool dtInferAsLemmas__setByUser__; \
  dtRefIntro__option_t::type dtRefIntro;\
  bool dtRefIntro__setByUser__; \
  dtRewriteErrorSel__option_t::type dtRewriteErrorSel;\
  bool dtRewriteErrorSel__setByUser__; \
  dtSharedSelectors__option_t::type dtSharedSelectors;\
  bool dtSharedSelectors__setByUser__; \
  dtUseTesters__option_t::type dtUseTesters;\
  bool dtUseTesters__setByUser__; \
  sygusAbortSize__option_t::type sygusAbortSize;\
  bool sygusAbortSize__setByUser__; \
  sygusEvalBuiltin__option_t::type sygusEvalBuiltin;\
  bool sygusEvalBuiltin__setByUser__; \
  sygusFairMax__option_t::type sygusFairMax;\
  bool sygusFairMax__setByUser__; \
  sygusFair__option_t::type sygusFair;\
  bool sygusFair__setByUser__; \
  sygusOpt1__option_t::type sygusOpt1;\
  bool sygusOpt1__setByUser__; \
  sygusSymBreak__option_t::type sygusSymBreak;\
  bool sygusSymBreak__setByUser__; \
  sygusSymBreakDynamic__option_t::type sygusSymBreakDynamic;\
  bool sygusSymBreakDynamic__setByUser__; \
  sygusSymBreakLazy__option_t::type sygusSymBreakLazy;\
  bool sygusSymBreakLazy__setByUser__; \
  sygusSymBreakPbe__option_t::type sygusSymBreakPbe;\
  bool sygusSymBreakPbe__setByUser__; \
  sygusSymBreakRlv__option_t::type sygusSymBreakRlv;\
  bool sygusSymBreakRlv__setByUser__;


namespace CVC4 {

namespace options {

extern struct CVC4_PUBLIC cdtBisimilar__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} cdtBisimilar CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtBinarySplit__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtBinarySplit CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtBlastSplits__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtBlastSplits CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtCyclic__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtCyclic CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtForceAssignment__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} dtForceAssignment CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtInferAsLemmas__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtInferAsLemmas CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtRefIntro__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtRefIntro CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtRewriteErrorSel__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} dtRewriteErrorSel CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtSharedSelectors__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtSharedSelectors CVC4_PUBLIC;
extern struct CVC4_PUBLIC dtUseTesters__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} dtUseTesters CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusAbortSize__option_t
{
  typedef int type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusAbortSize CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusEvalBuiltin__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusEvalBuiltin CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusFairMax__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusFairMax CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusFair__option_t
{
  typedef CVC4::theory::SygusFairMode type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusFair CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusOpt1__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusOpt1 CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSymBreak__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusSymBreak CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSymBreakDynamic__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusSymBreakDynamic CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSymBreakLazy__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusSymBreakLazy CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSymBreakPbe__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
  void set(const type& v);
} sygusSymBreakPbe CVC4_PUBLIC;
extern struct CVC4_PUBLIC sygusSymBreakRlv__option_t
{
  typedef bool type;
  type operator()() const;
  bool wasSetByUser() const;
} sygusSymBreakRlv CVC4_PUBLIC;


}  // namespace options

template <> const options::cdtBisimilar__option_t::type& Options::operator[](
    options::cdtBisimilar__option_t) const;
template <> bool Options::wasSetByUser(options::cdtBisimilar__option_t) const;
template <> void Options::assignBool(
    options::cdtBisimilar__option_t,
    std::string option,
    bool value);
template <> const options::dtBinarySplit__option_t::type& Options::operator[](
    options::dtBinarySplit__option_t) const;
template <> bool Options::wasSetByUser(options::dtBinarySplit__option_t) const;
template <> void Options::assignBool(
    options::dtBinarySplit__option_t,
    std::string option,
    bool value);
template <> const options::dtBlastSplits__option_t::type& Options::operator[](
    options::dtBlastSplits__option_t) const;
template <> bool Options::wasSetByUser(options::dtBlastSplits__option_t) const;
template <> void Options::assignBool(
    options::dtBlastSplits__option_t,
    std::string option,
    bool value);
template <> const options::dtCyclic__option_t::type& Options::operator[](
    options::dtCyclic__option_t) const;
template <> bool Options::wasSetByUser(options::dtCyclic__option_t) const;
template <> void Options::assignBool(
    options::dtCyclic__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::dtForceAssignment__option_t,
    const options::dtForceAssignment__option_t::type& x);
template <> const options::dtForceAssignment__option_t::type& Options::operator[](
    options::dtForceAssignment__option_t) const;
template <> bool Options::wasSetByUser(options::dtForceAssignment__option_t) const;
template <> void Options::assignBool(
    options::dtForceAssignment__option_t,
    std::string option,
    bool value);
template <> const options::dtInferAsLemmas__option_t::type& Options::operator[](
    options::dtInferAsLemmas__option_t) const;
template <> bool Options::wasSetByUser(options::dtInferAsLemmas__option_t) const;
template <> void Options::assignBool(
    options::dtInferAsLemmas__option_t,
    std::string option,
    bool value);
template <> const options::dtRefIntro__option_t::type& Options::operator[](
    options::dtRefIntro__option_t) const;
template <> bool Options::wasSetByUser(options::dtRefIntro__option_t) const;
template <> void Options::assignBool(
    options::dtRefIntro__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::dtRewriteErrorSel__option_t,
    const options::dtRewriteErrorSel__option_t::type& x);
template <> const options::dtRewriteErrorSel__option_t::type& Options::operator[](
    options::dtRewriteErrorSel__option_t) const;
template <> bool Options::wasSetByUser(options::dtRewriteErrorSel__option_t) const;
template <> void Options::assignBool(
    options::dtRewriteErrorSel__option_t,
    std::string option,
    bool value);
template <> const options::dtSharedSelectors__option_t::type& Options::operator[](
    options::dtSharedSelectors__option_t) const;
template <> bool Options::wasSetByUser(options::dtSharedSelectors__option_t) const;
template <> void Options::assignBool(
    options::dtSharedSelectors__option_t,
    std::string option,
    bool value);
template <> const options::dtUseTesters__option_t::type& Options::operator[](
    options::dtUseTesters__option_t) const;
template <> bool Options::wasSetByUser(options::dtUseTesters__option_t) const;
template <> void Options::assignBool(
    options::dtUseTesters__option_t,
    std::string option,
    bool value);
template <> const options::sygusAbortSize__option_t::type& Options::operator[](
    options::sygusAbortSize__option_t) const;
template <> bool Options::wasSetByUser(options::sygusAbortSize__option_t) const;
template <> void Options::assign(
    options::sygusAbortSize__option_t,
    std::string option,
    std::string value);
template <> const options::sygusEvalBuiltin__option_t::type& Options::operator[](
    options::sygusEvalBuiltin__option_t) const;
template <> bool Options::wasSetByUser(options::sygusEvalBuiltin__option_t) const;
template <> void Options::assignBool(
    options::sygusEvalBuiltin__option_t,
    std::string option,
    bool value);
template <> const options::sygusFairMax__option_t::type& Options::operator[](
    options::sygusFairMax__option_t) const;
template <> bool Options::wasSetByUser(options::sygusFairMax__option_t) const;
template <> void Options::assignBool(
    options::sygusFairMax__option_t,
    std::string option,
    bool value);
template <> const options::sygusFair__option_t::type& Options::operator[](
    options::sygusFair__option_t) const;
template <> bool Options::wasSetByUser(options::sygusFair__option_t) const;
template <> void Options::assign(
    options::sygusFair__option_t,
    std::string option,
    std::string value);
template <> const options::sygusOpt1__option_t::type& Options::operator[](
    options::sygusOpt1__option_t) const;
template <> bool Options::wasSetByUser(options::sygusOpt1__option_t) const;
template <> void Options::assignBool(
    options::sygusOpt1__option_t,
    std::string option,
    bool value);
template <> const options::sygusSymBreak__option_t::type& Options::operator[](
    options::sygusSymBreak__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSymBreak__option_t) const;
template <> void Options::assignBool(
    options::sygusSymBreak__option_t,
    std::string option,
    bool value);
template <> const options::sygusSymBreakDynamic__option_t::type& Options::operator[](
    options::sygusSymBreakDynamic__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSymBreakDynamic__option_t) const;
template <> void Options::assignBool(
    options::sygusSymBreakDynamic__option_t,
    std::string option,
    bool value);
template <> const options::sygusSymBreakLazy__option_t::type& Options::operator[](
    options::sygusSymBreakLazy__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSymBreakLazy__option_t) const;
template <> void Options::assignBool(
    options::sygusSymBreakLazy__option_t,
    std::string option,
    bool value);
template <> void Options::set(
    options::sygusSymBreakPbe__option_t,
    const options::sygusSymBreakPbe__option_t::type& x);
template <> const options::sygusSymBreakPbe__option_t::type& Options::operator[](
    options::sygusSymBreakPbe__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSymBreakPbe__option_t) const;
template <> void Options::assignBool(
    options::sygusSymBreakPbe__option_t,
    std::string option,
    bool value);
template <> const options::sygusSymBreakRlv__option_t::type& Options::operator[](
    options::sygusSymBreakRlv__option_t) const;
template <> bool Options::wasSetByUser(options::sygusSymBreakRlv__option_t) const;
template <> void Options::assignBool(
    options::sygusSymBreakRlv__option_t,
    std::string option,
    bool value);


namespace options {

inline cdtBisimilar__option_t::type cdtBisimilar__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool cdtBisimilar__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtBinarySplit__option_t::type dtBinarySplit__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtBinarySplit__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtBlastSplits__option_t::type dtBlastSplits__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtBlastSplits__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtCyclic__option_t::type dtCyclic__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtCyclic__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtForceAssignment__option_t::type dtForceAssignment__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtForceAssignment__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void dtForceAssignment__option_t::set(const dtForceAssignment__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline dtInferAsLemmas__option_t::type dtInferAsLemmas__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtInferAsLemmas__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtRefIntro__option_t::type dtRefIntro__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtRefIntro__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtRewriteErrorSel__option_t::type dtRewriteErrorSel__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtRewriteErrorSel__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void dtRewriteErrorSel__option_t::set(const dtRewriteErrorSel__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline dtSharedSelectors__option_t::type dtSharedSelectors__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtSharedSelectors__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline dtUseTesters__option_t::type dtUseTesters__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool dtUseTesters__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusAbortSize__option_t::type sygusAbortSize__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusAbortSize__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusEvalBuiltin__option_t::type sygusEvalBuiltin__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusEvalBuiltin__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusFairMax__option_t::type sygusFairMax__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusFairMax__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusFair__option_t::type sygusFair__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusFair__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusOpt1__option_t::type sygusOpt1__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusOpt1__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusSymBreak__option_t::type sygusSymBreak__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSymBreak__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusSymBreakDynamic__option_t::type sygusSymBreakDynamic__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSymBreakDynamic__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusSymBreakLazy__option_t::type sygusSymBreakLazy__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSymBreakLazy__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline sygusSymBreakPbe__option_t::type sygusSymBreakPbe__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSymBreakPbe__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}
inline void sygusSymBreakPbe__option_t::set(const sygusSymBreakPbe__option_t::type& v)
{
  Options::current()->set(*this, v);
}
inline sygusSymBreakRlv__option_t::type sygusSymBreakRlv__option_t::operator()() const
{
  return (*Options::current())[*this];
}
inline bool sygusSymBreakRlv__option_t::wasSetByUser() const
{
  return Options::current()->wasSetByUser(*this);
}


}  // namespace options
}  // namespace CVC4

#endif /* __CVC4__OPTIONS__DATATYPES_H */
