
#include "misystemtray.h"
#include <kpopupmenu.h>
#include <kapp.h>
#include <qcursor.h>
#include <qmessagebox.h>
#include "intern.h"
#include "pixmaps/exit.xpm"

MiSystemTray::MiSystemTray( QWidget* parent, const char* name)
        : KSystemTray( parent, name) 
{
	_menu= new KPopupMenu(this, "menu_misystemtray");
	_menu->insertTitle( "kwordtrans" );
	restaurar_item= _menu->insertItem( _("Restore"), this, SLOT( switch_restaurar() ) );
	_menu->insertItem( QPixmap( exit_xpm), _("&Quit"), this, SLOT( salir() ) );
	//restaurar_widget=true;

	connect( _menu, SIGNAL(aboutToShow()), this, SLOT(prepara_menu()) );
}

MiSystemTray::~MiSystemTray() {
	delete _menu;
}

void MiSystemTray::prepara_menu() {
	if (parentWidget()->isVisible()) {
		_menu->changeItem( restaurar_item, _("Minimize") );
		//restaurar_widget=false;
	} else {
		_menu->changeItem( restaurar_item, _("Restore") );
		//restaurar_widget=true;
	}
}

void MiSystemTray::mousePressEvent( QMouseEvent *e ) {
	if ( e->button()==RightButton ) {
		_menu->exec( QCursor::pos() );
	} else {
		KSystemTray::mousePressEvent(e);
	}
}

void MiSystemTray::mouseReleaseEvent( QMouseEvent *e ) {
}

void MiSystemTray::switch_restaurar() {
	if (parentWidget()->isVisible()) {
		parentWidget()->hide();
	} else {
		parentWidget()->show();
	}
}

void MiSystemTray::salir() {
	if ( QMessageBox::information( this, _("Exit from kwordtrans?"),
	                   _("Do you really want to leave kwordtrans?"),
                       _("&Yes"), _("&No"), 0,
                       0, 1 ) == 0 ) 
	{
		parentWidget()->close();
		kapp->closeAllWindows();
		kapp->quit();
	}
}

#include "misystemtray.moc.cpp"

