/* (C) 1998 Justin Schoeman */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

#ifdef NTSC
#define SPF (double)((double)44100/(double)60) /* NTSC */
#else
#define SPF (double)((double)44100/(double)50) /* PAL */
#endif

int main(int argc, char** argv)
{
 int in, out;
 char fname[255];
 unsigned char audiobuf[65536];
 char *a_name, *v_name;
 int rd, padding, cnt;
 unsigned int vidfirst, vidlast, audiofirst=0xffffffffUL, audiolast, audiobytes=0;
 double fpsi, fpso, fin,fout;
 
 if((argc<2)|(argc>3))
 {
  fprintf(stderr, "Usage:\n\n");
  fprintf(stderr, " audioconv <audio stream> <first video stream file>\n\n");
  exit(0);
 }
 v_name=argv[2];
 a_name=argv[1];
 
 fprintf(stderr, "Scanning video file:\n");
 in=open(v_name, O_RDONLY);
 read(in, &rd, sizeof(rd)); /*width*/
 read(in, &rd, sizeof(rd)); /*height*/
 read(in, &vidlast, sizeof(vidlast));
 read(in, &vidfirst, sizeof(vidfirst));
 close(in);
 fprintf(stderr, "First videoframe: %u  Last videoframe: %u\n", vidfirst, vidlast);
 
 in=open(a_name,O_RDONLY);
 sprintf(fname,"%s.out", a_name);
 out=open(fname, O_RDWR|O_TRUNC|O_CREAT, S_IRUSR|S_IWUSR);
 
 fprintf(stderr, "Scanning audio file:\n");
 while(read(in, &rd, sizeof(rd))==sizeof(rd))
 {
  audiobytes+=rd;
  read(in, &audiolast, sizeof(audiolast));
  fprintf(stderr, ".");
  if (audiofirst==0xffffffffUL)audiofirst=audiolast;
  if (audiolast<vidfirst)
  {
   audiofirst=0xffffffffUL;
   audiobytes=0;
  }
  read(in, &audiobuf, rd);
 }
 fpsi=(double)(audiolast-audiofirst)/(double)(audiobytes>>1);
 fpso=1/SPF;

 if(audiolast>vidlast)audiolast=vidlast;
 fprintf(stderr, "\nFirst audioframe: %u  Last audioframe: %u Audio bytes: %d\n", audiofirst, audiolast, audiobytes);
 padding=(int)((audiofirst-vidfirst)*SPF);
 fprintf(stderr, "Padding required: %d frames = %d samples\n", audiofirst-vidfirst, padding);
 fprintf(stderr, "Writing padding:\n");
 rd=0;
 for(cnt=0; cnt<padding; cnt++)write(out, &rd, 2);
 padding=(int)((vidlast-audiolast)*SPF);
 fprintf(stderr, "Converting data:\n");
 lseek(in, 0, SEEK_SET);
 fin=0;
 fout=0;
 while(read(in, &rd, sizeof(rd))==sizeof(rd))
 {
  read(in, &vidlast, sizeof(vidlast));
  read(in, &audiobuf, rd);
  fprintf(stderr, ".");
  if (vidlast>=audiofirst) /* found start of data */
  {
   for(cnt=0; cnt<(rd>>1); cnt++)
   {
    write(out, &audiobuf[cnt*2], 2);
    fout=fout+fpso;
    fin=fin+fpsi;
    if(fin>fout)
    {
     while(fin>(fout+fpso))
     {
      write(out, &audiobuf[cnt*2], 2);
      fout=fout+fpso;
     }
    } else if(fin<fout)
    {
     while((fin+fpsi)<fout)
     {
      cnt++;
      fin=fin+fpsi;
     }
    } 
   }
  }
 }
 rd=0;
 for(cnt=0; cnt<padding; cnt++)write(out, &rd, 2);
 fprintf(stderr, "\nDone.\n");
 
 close(in);
 close(out);
 return 0;
}
