/**********************************************************************
 * File:        drawedg.h  (Formerly drawedge.h)
 * Description: Collection of functions to draw things to do with edge detection.
 * Author:					Ray Smith
 * Created:					Thu Jun 06 13:29:20 BST 1991
 *
 * (C) Copyright 1991, Hewlett-Packard Ltd.
 ** Licensed under the Apache License, Version 2.0 (the "License");
 ** you may not use this file except in compliance with the License.
 ** You may obtain a copy of the License at
 ** http://www.apache.org/licenses/LICENSE-2.0
 ** Unless required by applicable law or agreed to in writing, software
 ** distributed under the License is distributed on an "AS IS" BASIS,
 ** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 ** See the License for the specific language governing permissions and
 ** limitations under the License.
 *
 **********************************************************************/

#ifndef           DRAWEDG_H
#define           DRAWEDG_H

#include          "grphics.h"
#include          "crakedge.h"

WINDOW create_edges_window(                //make window
                           ICOORD page_tr  //size of image
                          );
void draw_raw_edge(                   //draw the cracks
                   WINDOW fd,         //window to draw in
                   CRACKEDGE *start,  //start of loop
                   COLOUR colour      //colour to draw in
                  );
void draw_edge_needles(                   //draw gradients
                       WINDOW fd,         //window to draw in
                       CRACKEDGE *start,  //start of outline
                       COLOUR colour      //colour to draw in
                      );
#endif
