/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_FILEDIALOG_H
#define _SC_FILEDIALOG_H

// sc

// qt
#include <qdialog.h>
#include <qdir.h>
class QPixmap;
class QListView;
class QListViewItem;
class QPushButton;


/**
 * Dialog for selecting a file system path.
 */
class FileDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  FileDialog( QWidget *parent = 0, const char *name=0 );
  virtual ~FileDialog();

  void setSource( const QString& root );
  QString getSelection();

  void setDirsOnly( bool );

public slots:
  void selectionChanged( QListViewItem* );
  void expanded( QListViewItem* );
  void parent();

private:
  void drives();

  QDir             _dir;
  bool             _dirsOnly;

  QString          _root;

  QListView*       _list;
  QPushButton*     _parent;

  QPixmap*         _folder;
};

#endif // _SC_FILEDIALOG_H
