#ifndef _sinforequester_h
#define _sinforequester_h


#include <boost/signal.hpp>
#include "sinfodata.h"
#include "message.h"
#include "protocoltimer.h"


class SinfoRequester
{
private:
  SinfoData & sinfoData;

  ProtocolTimer waitForConnectionReadyTimer;
  void waitForConnectionReadyTimerExpiredEvent();

  void requestUpdate();

  ProtocolTimer requestUpdateTimer;
  void requestUpdateTimerExpiredEvent();

  ProtocolTimer periodicRequestTimer;
  void periodicRequestTimerExpiredEvent();

public:
  unsigned long delay_millisec;
  unsigned long timeout_millisec;
  std::string filterMarker;
  bool stopAfterOneRequest;

  SinfoRequester(ProtocolIO & protocolIO, SinfoData & _sinfoData);

  void connectionReadySlot();
  boost::signal<void (Message & message)> queueAndSendMessageSignal;
  void receivedMessageSlot(Message & returnMessage);
  boost::signal<void ()> timeoutSignal;
};


#endif
