/* @(#)gettnum.c	1.5 06/09/13 Copyright 1984-2002, 2004 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)gettnum.c	1.5 06/09/13 Copyright 1984-2002, 2004 J. Schilling";
#endif
/*
 *	Time conversion routines rewritten from number conversion in 'sdd'.
 *
 *	Copyright (c) 1984-2002, 2004 J. Schilling
 */
/*
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * See the file CDDL.Schily.txt in this distribution for details.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file CDDL.Schily.txt from this distribution.
 */

#include <schily/mconfig.h>
#include <schily/standard.h>
#include <schily/utypes.h>
#include <schily/time.h>
#include <schily/schily.h>
#include <schily/nlsdefs.h>
#include "gettnum.h"

#define	MINSECS		(60)
#define	HOURSECS	(60  * MINSECS)
#define	DAYSECS		(24  * HOURSECS)
#define	WEEKSECS	(7   * DAYSECS)
#define	YEARSECS	(365 * DAYSECS)		/* A non leap year */


LOCAL	Llong	tnumber		__PR((char *arg, int *retp, int level));
EXPORT	int	gettnum		__PR((char *arg, time_t *valp));

LOCAL Llong
tnumber(arg, retp, level)
	register char	*arg;
		int	*retp;
		int	level;
{
	Llong	val	= 0;

	if (*retp != 1)
		return (val);
	if (*arg == '\0') {
		*retp = -1;
	} else if (*(arg = astoll(arg, &val))) {
		if (*arg == 's') {
			val *= 1;
			arg++;

		} else if (*arg == 'm') {
			val *= MINSECS;
			arg++;

		} else if (*arg == 'h') {
			val *= HOURSECS;
			arg++;

		} else if (*arg == 'd') {
			val *= DAYSECS;
			arg++;

		} else if (*arg == 'w') {
			val *= WEEKSECS;
			arg++;

		} else if (*arg == 'y') {
			val *= YEARSECS;
			arg++;

		}
		if (*arg >= '0' && *arg <= '9')
			val += tnumber(arg, retp, level+1);
		else if (*arg != '\0') {
			errmsgno(EX_BAD,
			gettext("Illegal character '%c' in timespec.\n"),
				*arg);
			*retp = -1;
		} else if (*arg == '\0')
			return (val);
	}
	if (level > 0 && *arg == '\0')
		*retp = -1;
	return (val);
}

EXPORT int
gettnum(arg, valp)
	char	*arg;
	time_t	*valp;
{
	Llong	llval;
	int	ret = 1;

	llval = tnumber(arg, &ret, 0);
	*valp = llval;
	if (*valp != llval) {
		errmsgno(EX_BAD,
		gettext("Value %lld is too large for data type 'time_t'.\n"),
									llval);
		ret = -1;
	}
	return (ret);
}
