% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print}
\alias{print}
\alias{print.ten}
\alias{print.COV}
\alias{print.lrt}
\alias{print.sup}
\alias{print.tableAndPlot}
\alias{print.stratTableAndPlot}
\title{\code{print} methods}
\usage{
\method{print}{ten}(x, ..., maxRow = getOption("datatable.print.nrows", 50L),
  nRowP = getOption("datatable.print.topn", 5L), pRowNames = TRUE,
  maxCol = getOption("survMisc.maxCol", 8L),
  nColSP = getOption("survMisc.nColSP", 7L),
  sigDig = getOption("survMisc.sigDig", 2L))

\method{print}{COV}(x, ..., n = 2L)

\method{print}{lrt}(x, ..., dist = c("n", "c"))

\method{print}{sup}(x, ...)

\method{print}{tableAndPlot}(x, ..., hideTabLeg = TRUE, tabHeight = 0.25)

\method{print}{stratTableAndPlot}(x, ..., hideTabLeg = TRUE,
  tabHeight = 0.25)
}
\arguments{
\item{x}{An object of class \code{ten}.}

\item{...}{Additional arguments (not implemented).
 \cr \cr
\bold{--print.ten}}

\item{maxRow}{Maximum number of rows to print.
 \cr
If \code{nrow(x) > maxRow}, just the first and last
\code{nRowP} (below) are printed.
 \cr
The default value is that used by \code{data.table}.}

\item{nRowP}{\bold{N}umber of rows to \bold{p}rint from
the start and end of the object. Used if \code{nrow(x) > maxRow}.}

\item{pRowNames}{Print row names? 
 \cr
Default is \code{TRUE}.}

\item{maxCol}{Maximum number of columns to print.
 \cr
If \code{ncol(x) > maxCol}, just the first \code{nColSP}
and last \code{maxCol - nColSP} columns are printed.}

\item{nColSP}{\bold{N}umber of \bold{col}umns to \bold{p}rint from
the \bold{s}tart of the object. Used if Used if \code{ncol(x) > maxCol}.}

\item{sigDig}{\bold{Sig}nificant \bold{dig}its. This is passed as an argument to
 \cr
?signif
 \cr
when preparing the object for printing.
 \cr \cr
\bold{--print.tableAndPlot} and \bold{print.tableAndPlot}}

\item{n}{Similar to \code{n} from e.g. 
 \cr
?utils::head
 \cr \cr
\bold{--print.lrt}}

\item{dist}{Which distribution to use for the statistics
when printing.
 \cr
Default (\code{dist="n"}) prints \eqn{Z} and \eqn{p} values
based on the normal distribution. 
 \cr
If \code{dist="c"}, gives values based on the 
\eqn{\chi^2}{chi-squared} distribution. 
 \cr
The results are the same. The default value is typically 
easier to read. Both options are given for completeness.}

\item{hideTabLeg}{Hide table legend.}

\item{tabHeight}{Table height (relative to whole plot).
 \cr \cr
\bold{--print.COV}}
}
\value{
A printed representation of the object
is send to the terminal as a \emph{side effect} of
calling the function.
 \cr
The return value cannot be \code{assign}ed.
}
\description{
\code{print} methods
}
\details{
Prints a \code{ten} object with 'nice' formatting.
 \cr
Options may be set for a session using e.g.
 \cr
options(survMisc.nColSP=4L)
 \cr
It is similar to the behavior of \code{print.data.table} but
has additional arguments controlling the number of columns
sent to the terminal.
}
\note{
All numeric arguments to the function must be supplied as integers.
}
\examples{
set.seed(1)
(x <- data.table::data.table(matrix(rnorm(1800), ncol=15, nrow=120)))
data.table::setattr(x, "class", c("ten", class(x)))
p1 <- print(x)
stopifnot(is.null(p1))
x[1:80, ]
x[0, ]
(data.table::set(x, j=seq.int(ncol(x)), value=NULL))

}
\seealso{
For \code{print.ten}:

data.table:::print.data.table

?stats::printCoefmat

options()$datatable.print.nrows

sapply(c("datatable.print.nrows", "datatable.print.topn"), getOption)
}
\author{
Chris Dardis. Based on existing work by Brian Diggs.
}
