% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-anova-tidiers.R
\name{tidy.aovlist}
\alias{tidy.aovlist}
\title{Tidy a(n) aovlist object}
\usage{
\method{tidy}{aovlist}(x, ...)
}
\arguments{
\item{x}{An \code{aovlist} objects, such as those created by \code{\link[stats:aov]{stats::aov()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.level = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
The \code{term} column of an ANOVA table can come with leading or
trailing whitespace, which this tidying method trims.

For documentation on the tidier for \code{\link[car:leveneTest]{car::leveneTest()}} output, see
\code{\link[=tidy.leveneTest]{tidy.leveneTest()}}
}
\examples{

a <- aov(mpg ~ wt + qsec + Error(disp / am), mtcars)
tidy(a)
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[stats:aov]{stats::aov()}}

Other anova tidiers: 
\code{\link{glance.aov}()},
\code{\link{tidy.TukeyHSD}()},
\code{\link{tidy.anova}()},
\code{\link{tidy.aov}()},
\code{\link{tidy.manova}()}
}
\concept{anova tidiers}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{df}{Degrees of freedom used by this term in the model.}
  \item{meansq}{Mean sum of squares. Equal to total sum of squares divided by degrees of freedom.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{statistic}{The value of a T-statistic to use in a hypothesis that the regression term is non-zero.}
  \item{stratum}{The error stratum.}
  \item{sumsq}{Sum of squares explained by this term.}
  \item{term}{The name of the regression term.}

}
