% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f.pvalue.R
\name{f.pvalue}
\alias{f.pvalue}
\title{A function for quickly calculating f statistic p-values for use in sva}
\usage{
f.pvalue(dat, mod, mod0)
}
\arguments{
\item{dat}{The transformed data matrix with the variables in rows and samples in columns}

\item{mod}{The model matrix being used to fit the data}

\item{mod0}{The null model being compared when fitting the data}
}
\value{
p A vector of F-statistic p-values one for each row of dat.
}
\description{
This function does simple linear algebra to calculate f-statistics
for each row of a data matrix comparing the nested models
defined by the design matrices for the alternative (mod) and and null (mod0) cases.
The columns of mod0 must be a subset of the columns of mod.
}
\examples{
library(bladderbatch)
data(bladderdata)
dat <- bladderEset[1:50,]

pheno = pData(dat)
edata = exprs(dat)
mod = model.matrix(~as.factor(cancer), data=pheno)
mod0 = model.matrix(~1,data=pheno)

pValues = f.pvalue(edata,mod,mod0)
qValues = p.adjust(pValues,method="BH")

}
