/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2000  The plex86 developers team
 *
 *  elf.c: load an ELF kernel image into VM memory
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>

#include "bios.h"
#include "multiboot.h"


plugin_t *bios_plugin;


  int
plugin_init(plugin_t *plugin, int argc, char *argv[])
{
  char *address_p, *filename_p, *stack_p, *hack_p, *rd_p;
  Bit32u address, stack;
  Bit32u rd_address, rd_size;

  unsigned i;
unsigned hack_linux;

#define FILE_PARAM    "file="
#define ADDRESS_PARAM "address="
#define STACK_PARAM   "stack="
#define HACK_PARAM    "hack="
#define RD_PARAM      "rd="

  bios_plugin = plugin;

  /* Get the file= parameter */
  i = 0;
  if ( !argv[i] || strncmp(argv[i], FILE_PARAM, strlen(FILE_PARAM)) )
    goto usage;
  filename_p = &argv[i][strlen(FILE_PARAM)];
  i++;

  /********************************/
  /* Get the [address=] parameter */
  /********************************/
  if ( !argv[i] || strncmp(argv[i], ADDRESS_PARAM, strlen(ADDRESS_PARAM)) ) {
    address = -1; /* not given, assign max val as flag */
    }
  else {
    address_p  = &argv[i][strlen(ADDRESS_PARAM)];
    address = strtoul(address_p, NULL, 0);
    i++;
    }

  /******************************/
  /* Get the [stack=] parameter */
  /******************************/
  if ( !argv[i] || strncmp(argv[i], STACK_PARAM, strlen(STACK_PARAM)) )
    goto usage;
  stack_p  = &argv[i][strlen(STACK_PARAM)];
  stack   = strtoul(stack_p, NULL, 0);
  i++;

  /***************************************/
  /* Get the [rd=address:path] parameter */
  /***************************************/
  if ( (i>=argc) || !argv[i] || strncmp(argv[i], RD_PARAM, strlen(RD_PARAM)) )
    {
    rd_address = 0xffffffff;
    rd_size = 0;
    }
  else {
    char *endptr;

    rd_p  = &argv[i][strlen(RD_PARAM)];
    rd_address = strtoul(rd_p, &endptr, 0);
    if (*endptr==':') {
      endptr++;
      rd_size = image_load(endptr, rd_address);
      if (rd_size==0) {
        fprintf(stderr, "loading of rd image '%s' failed.\n", endptr);
        return 1;
        }
      }
    else {
      fprintf(stderr, "format of rd= parameter incorrect\n");
      return 1;
      }
    i++;
    }

  /*******************************/
  /* Get the [hack=os] parameter */
  /*******************************/
hack_linux = 0;
  if ( (i>=argc) || !argv[i] || strncmp(argv[i], HACK_PARAM, strlen(HACK_PARAM)) )
    {
    }
  else {
    hack_p  = &argv[i][strlen(HACK_PARAM)];
    if ( !strcmp(hack_p, "linux") ) {
      load_linux_setup_params(rd_address, rd_size);
      if (linux_hack()) {
        fprintf(stderr, "linux_hack returns error.\n");
        return 1;
        }
hack_linux = 1;
      }
    else {
      fprintf(stderr, "'hack=' parameter, unrecognized OS.\n");
      return 1;
      }
    i++;
    }

  vm_conf.stack_address = stack;

  if (bin_load(filename_p, address)) {
    fprintf(stderr, "loading of kernel '%s' failed.\n", filename_p);
    return 1;
    }

  bin_context(hack_linux);

  return 0;

usage:
  fprintf(stderr, "usage: plugin-elf file=path [address=num] stack=num\n");
  return 1;
}


void
plugin_fini(void)
{
    return;
}
