/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  instrument-mon.c: Some instrumentation logic for the VM.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#include "plex86.h"
#define IN_MONITOR_SPACE
#include "monitor.h"


#ifdef DoInstrEmulateOpcode


// xxx Not multiple-VM compatible.  Needs to be in vm-> for that.
static struct {
  unsigned standard[512];
  unsigned groups[NumGroups][8];
  } emulateOpcodeFrequency;

  void
instrEmulateOpcode(vm_t *vm)
{
  if ( vm->i.attr & GroupN ) {
    unsigned group;
    group = GetGroupIndex(vm->i.attr);
    emulateOpcodeFrequency.groups[group][vm->i.nnn]++;
    }
  else {
    emulateOpcodeFrequency.standard[vm->i.b1]++;
    }
}

  void
instrReset(vm_t *vm)
{
  mon_memzero(&emulateOpcodeFrequency, sizeof(emulateOpcodeFrequency));
}
  void
instrPrint(vm_t *vm)
{
  unsigned i, nnn, g;

  for (i=0; i<512; i++)
    if (emulateOpcodeFrequency.standard[i])
      monprint(vm, "OPF[%x]: %u\n", i, emulateOpcodeFrequency.standard[i]);
  for (g=0; g<NumGroups; g++)
    for (nnn=0; nnn<8; nnn++)
      if (emulateOpcodeFrequency.groups[g][nnn])
        monprint(vm, "OPF G%u[%x]: %u\n", g, nnn,
                 emulateOpcodeFrequency.groups[g][nnn]);
}
#endif
