/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999  Kevin P. Lawton
 *
 *  virtcode.c:  This file contains the test code to run in the VM
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#include "virtcode.h"

asm (
    ".text; .globl _start           \n"
    "_start:                        \n"
    "    movw %ss, %ax              \n"  /* Setup the segment registers */
    "    movw %ax, %ds              \n"
    "    movw %ax, %es              \n"
    "    movw %ax, %fs              \n"
    "    movw %ax, %gs              \n"
    "    call do_nothing            \n"  /* Run the test code           */
    "1:  jmp 1b                     \n"  /* Should never get here       */
);


void
do_nothing(void)
{
    if(init_keyboard()<0) return;
    clear_screen();
    /* we're go !! */
    printstr("Hello, world !!\n\n");
    printstr("Try pressing some keys...\n");

    /* execute minishell; should never return */
    minishell();
}
