/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001  Kevin P. Lawton
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __CODEGEN_H
#define __CODEGEN_H

#include "../dt.h"



/* Defines */

#define RegEAX 0
#define RegECX 1
#define RegEDX 2
#define RegEBX 3
#define RegESP 4
#define RegEBP 5
#define RegESI 6
#define RegEDI 7



/* Data structures */

typedef struct {
  Bit32u *tcodePtr;
  Bit32u tcodeOff;
} dtRelocRec_t;



/* Variable declarations */

extern dtRelocRec_t reloc[];
extern unsigned relocN;



/* Function declarations */

Bit8u *dtGenRet(Bit8u * tcodePtr);
Bit8u *dtGenJmpEcx4(Bit8u * tcodePtr, Bit32u targetOffset32);
Bit8u *dtGenLoopJb(Bit8u * tcodePtr, Bit8s displ8);
Bit8u *dtGenJzJd(Bit8u * tcodePtr, Bit32u targetOffset32);
Bit8u *dtGenJnzJd(Bit8u * tcodePtr, Bit32u targetOffset32);
Bit8u *dtGenJmpJd(Bit8u * tcodePtr, Bit32u targetOffset32);



/*
 *  Code generators
 *
 *  The static, inlined functions generate executable code at the
 *  specified tcode address for specific instructions or sequences
 *  of instructions.
 */

#if 0
  static inline Bit8u *
dtEmitPrelude(Bit8u * tcodePtr, Bit32u gOff)
{
  /* cs; mov  r3h_DS, %ss   Load handler SS. */
  *tcodePtr++ = 0x2e;
  *tcodePtr++ = 0x8e;
  *tcodePtr++ = 0x15;
  *(Bit32u *) tcodePtr = (Bit32u) & r3h_DS;
  tcodePtr += 4;

  /* ss; movl %esp,  guest_ESP   Save guest ESP */
  *tcodePtr++ = 0x36;
  *tcodePtr++ = 0x89;
  *tcodePtr++ = 0x25;
  *(Bit32u *) tcodePtr = (Bit32u) & guest_ESP;
  tcodePtr += 4;

  /* ss; movl $guestSrcEIP, guest_EIP   Save guest source EIP */
  *tcodePtr++ = 0x36;
  *tcodePtr++ = 0xc7;
  *tcodePtr++ = 0x05;
  *(Bit32u *) tcodePtr = (Bit32u) & guest_EIP;
  tcodePtr += 4;
  *(Bit32u *) tcodePtr = gOff;
  tcodePtr += 4;

  /* ss; movl r3h_ESP_empty, %esp  Fully loaded handler SS:ESP */
  *tcodePtr++ = 0x36;
  *tcodePtr++ = 0x8b;
  *tcodePtr++ = 0x25;
  *(Bit32u *) tcodePtr = (Bit32u) & r3h_ESP_empty;
  tcodePtr += 4;

  return (tcodePtr);
}


  static inline Bit8u *
dtEmitPostlude(Bit8u * tcodePtr)
{
  /* cs; mov  guest_SS, %ss */
  *tcodePtr++ = 0x2e;
  *tcodePtr++ = 0x8e;
  *tcodePtr++ = 0x15;
  *(Bit32u *) tcodePtr = (Bit32u) & guest_SS;
  tcodePtr += 4;

  /* cs; mov guest_ESP, %esp */
  *tcodePtr++ = 0x2e;
  *tcodePtr++ = 0x8b;
  *tcodePtr++ = 0x25;
  *(Bit32u *) tcodePtr = (Bit32u) & guest_ESP;
  tcodePtr += 4;

  return (tcodePtr);
}
#endif


  static inline Bit8u *
dtEmitPushImm32(Bit8u * tcodePtr, Bit32u imm32)
{
  *tcodePtr++ = 0x68;
  *(Bit32u *) tcodePtr = imm32;
  tcodePtr += 4;

  return (tcodePtr);
}


  static inline Bit8u *
dtEmitRet(Bit8u * tcodePtr)
{
  *tcodePtr++ = 0xc3;

  return (tcodePtr);
}


  static inline Bit8u *
dtEmitUseR3hESP(Bit8u * tcodePtr)
{
  /* gs; movl %esp, guest_ESP */
  *tcodePtr++ = 0x65;
  *tcodePtr++ = 0x89;
  *tcodePtr++ = 0x25;
  *(Bit32u *) tcodePtr = (Bit32u) & guest_ESP;
  tcodePtr += 4;

  /* gs; movl r3h_ESP_empty, %esp */
  *tcodePtr++ = 0x65;
  *tcodePtr++ = 0x8b;
  *tcodePtr++ = 0x25;
  *(Bit32u *) tcodePtr = (Bit32u) & r3h_ESP_empty;
  tcodePtr += 4;

  return (tcodePtr);
}


  static inline Bit8u *
dtEmitUseGuestESP(Bit8u * tcodePtr)
{
  /* gs; movl guest_ESP, %esp */
  *tcodePtr++ = 0x65;
  *tcodePtr++ = 0x8b;
  *tcodePtr++ = 0x25;
  *(Bit32u *) tcodePtr = (Bit32u) & guest_ESP;
  tcodePtr += 4;

  return (tcodePtr);
}


  static inline Bit8u *
dtEmitPushf(Bit8u * tcodePtr)
{
  *tcodePtr++ = 0x9c;   /* pushfl */
  return (tcodePtr);
}


  static inline Bit8u *
dtEmitPopf(Bit8u * tcodePtr)
{
  *tcodePtr++ = 0x9d;   /* popfl */
  return (tcodePtr);
}


  static inline Bit8u *
dtEmitIDCheck(Bit8u * tcodePtr, Bit8u ** offsetPtr, Bit8u ** idPtr)
{
  /* cmpl $inline-ID, globalID */
  *tcodePtr++ = 0x81;
  *tcodePtr++ = 0x3d;
  *(Bit32u *) tcodePtr = (Bit32u) & globalID;
  tcodePtr += 4;
  /* Start ID at zero so the first compare creates a miss.  This is
   * dynamically patched by handler routine.
   */
  *idPtr = tcodePtr;
  *(Bit32u *) tcodePtr = 0;
  tcodePtr += 4;

  *tcodePtr++ = 0x75;
  *offsetPtr = tcodePtr;
  *tcodePtr++ = 0x00;   /* 8bit offset patched by DT engine */

  return (tcodePtr);
}


  static inline Bit8u *
dtEmitJmp(Bit8u * tcodePtr, Bit32u ** offsetPtr)
{
  *tcodePtr++ = 0xe9;   /* jmp Jv */
  *offsetPtr = (Bit32u *) tcodePtr;
  *(Bit32u *) tcodePtr = 0; /* Patched in by DT engine */
  tcodePtr += 4;
  return (tcodePtr);
}


  static inline Bit8u *
dtEmitCall(Bit8u * tcodePtr, Bit32u ** offsetPtr)
{
  *tcodePtr++ = 0xe8;   /* call Av */
  *offsetPtr = (Bit32u *) tcodePtr;
  *(Bit32u *) tcodePtr = 0; /* Patched in by DT engine */
  tcodePtr += 4;
  return (tcodePtr);
}


  static inline Bit8u *
dtEmitPushReg(Bit8u * tcodePtr, unsigned reg)
{
  *tcodePtr++ = 0x50 + reg;
  return (tcodePtr);
}


#endif /* __DT_H */
