#include "dt.h"

/* Simulate code in the real VM which switches between
 * monitor and guest code.  Since there really isn't a monitor
 * running, I cheat and only save minimal info.
 */

Bit32u mon_ESP;

asm (
  ".globl __mon2r3h \n\t"
  "__mon2r3h: \n\t"
  "  pushfl \n\t"
  "  pushal \n\t"
  "  movl %esp, mon_ESP \n\t" /* save monitor stack */
  "  movl r3h_ESP, %esp \n\t" /* restore to ring3 handler stack */
  "  popal \n\t" /* Restore r3h general registers */
  "  popfl \n\t" /* Restore r3h eflags */
  "  ret \n\t" /* return to code which made request */
  );

asm (
  ".globl __r3h2mon \n\t"
  "__r3h2mon: \n\t"
  "  pushfl \n\t" /* Save r3h eflags */
  "  pushal \n\t" /* Save r3h general registers */
  "  movl %esp, r3h_ESP \n\t" /* save monitor stack */
  "  movl mon_ESP, %esp \n\t" /* restore to ring3 handler stack */
  "  popal \n\t" /* Restore monitor general registers */
  "  popfl \n\t" /* Restore monitor eflags */
  "  ret \n\t" /* return to code which made request */
  );
