/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xmlmetai.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:16:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XMLOFF_XMLMETAI_HXX
#define _XMLOFF_XMLMETAI_HXX

#ifndef _SAL_CONFIG_H_
#include "sal/config.h"
#endif

#ifndef INCLUDED_XMLOFF_DLLAPI_H
#include "xmloff/dllapi.h"
#endif

#ifndef _XMLOFF_XMLICTXT_HXX
#include "xmlictxt.hxx"
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XDOCUMENTINFO_HPP_
#include <com/sun/star/document/XDocumentInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif

class SvXMLTokenMap;

namespace com { namespace sun { namespace star { namespace lang {
	struct Locale;
}}}}
namespace com { namespace sun { namespace star { namespace frame {
	class XModel;
}}}}


class XMLOFF_DLLPUBLIC SfxXMLMetaContext : public SvXMLImportContext
{
private:
	::com::sun::star::uno::Reference<
		::com::sun::star::document::XDocumentInfo>	xDocInfo;
	::com::sun::star::uno::Reference<
		::com::sun::star::beans::XPropertySet>		xInfoProp;
	::com::sun::star::uno::Reference<
		::com::sun::star::beans::XPropertySet>		xDocProp;
	SvXMLTokenMap*									pTokenMap;
	sal_Int32										nUserKeys;
	::rtl::OUStringBuffer							sKeywords;

public:
	SfxXMLMetaContext( SvXMLImport& rImport, sal_uInt16 nPrfx,
						const ::rtl::OUString& rLName,
						const ::com::sun::star::uno::Reference<
							::com::sun::star::frame::XModel>& rDocModel );
	SfxXMLMetaContext( SvXMLImport& rImport, sal_uInt16 nPrfx,
						const ::rtl::OUString& rLName,
						const ::com::sun::star::uno::Reference<
							::com::sun::star::document::XDocumentInfo>&	rDocInfo );
	virtual ~SfxXMLMetaContext();

	// Create child element.
	virtual SvXMLImportContext *CreateChildContext( sal_uInt16 nPrefix,
				const ::rtl::OUString& rLocalName,
				const ::com::sun::star::uno::Reference<
					::com::sun::star::xml::sax::XAttributeList>& xAttrList );

	virtual void EndElement();

	const ::com::sun::star::uno::Reference<
		::com::sun::star::beans::XPropertySet>& GetInfoProp() const
			{ return xInfoProp; }
	const ::com::sun::star::uno::Reference<
		::com::sun::star::beans::XPropertySet>& GetDocProp() const
			{ return xDocProp; }

	void	AddKeyword( const ::rtl::OUString& rKW );
	void	AddUserField( const ::rtl::OUString& rName,
							const ::rtl::OUString& rContent );
	void	AddUserField( const ::rtl::OUString& rName,
							const ::com::sun::star::uno::Any& rContent);
};



#endif // _XMLOFF_XMLMETAI_HXX

