/*
 * Control.java
 *
 * Created on 21. August 2002, 18:29
 */
package com.sun.star.wizards.tutorial.executer.util;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;

import java.util.Properties;

/**
 * Control class is meant for the mouse and the keyboard control.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public class Control extends Robot {
    private static Control m_con;
    private static Rectangle m_rectangle;
    private static int m_mousePoint_X = 0;
    private static int m_mousePoint_Y = 0;
    private static int m_autoMoveMouseDelay = 4;
    private static int m_moveMouseStep = 1;
    private static int m_autoMouseScrollDelay = 10;
    private static int m_autoKeyDelay = 0;
    private static boolean m_animate = true;
    private static boolean m_break = false;
    private static String m_mouseAnimateStyle = "LINE";
    public static final String MOUSE_SCROLL_UP = "UP";
    public static final String MOUSE_SCROLL_DOWN = "DOWN";
    public static final String MOUSE_CLICK_LEFT = "LEFT";
    public static final String MOUSE_CLICK_RIGHT = "RIGHT";
    public static final String MOUSE_CLICK_CENTER = "CENTER";
    public static final String MOUSE_ANIMATE_STYLE_BASIC = "BASIC";
    public static final String MOUSE_ANIMATE_STYLE_MENU = "MENU";
    public static final String MOUSE_ANIMATE_STYLE_LINE = "LINE";
    public static final int MOUSE_OS_WINDOWS_SPEED = 0;
    public static final int MOUSE_OS_LINUX_SPEED = 1;
    public static final int MOUSE_OS_SUNOS_SPEED = 2;

    static {
        try {
            new Control();
        } catch (AWTException e) {
        }
    }

    /**
     * Creates a new Control object.
     *
     * @throws AWTException
     */
    public Control() throws AWTException {
        super();
        m_rectangle = new Rectangle();
        resetMousePosition();
        m_con = this;
    }

    /**
     * Sleeps for the specified time. To catch any InterruptedExceptions that occur,
     * Thread.sleep() may be used instead.
     *
     * @param millis to sleep in milliseconds
     *
     * @throws IllegalArgumentException DOCUMENT ME!
     */
    public static synchronized void sleep(int millis) {
        if ((millis < 0) || (millis > 60000)) {
            throw new IllegalArgumentException("Delay must be to 0 to 60,000ms");
        } else {
            try {
                Thread.sleep(millis);
            } catch (InterruptedException ite) {
                //ite.printStackTrace();
            } catch (java.lang.Exception ex) {
            }
        }

        //m_con.delay(millis);
    }

    /**
     * Set the delay values for key, mouse and mouse scroll.
     *
     * @param keyMillis time to delay in milliseconds
     * @param mouseMillis time to delay in milliseconds
     * @param mouseScrollMillis scroll time to delay in milliseconds
     * @param mouseStep DOCUMENT ME!
     */
    public static void setDelay(int keyMillis, int mouseMillis, int mouseScrollMillis, int mouseStep) {
        m_con.m_autoKeyDelay = keyMillis;
        m_con.m_autoMoveMouseDelay = mouseMillis;
        m_con.m_autoMouseScrollDelay = mouseScrollMillis;
        m_con.setMoveMouseStep(mouseStep);
    }

    /**
     * DOCUMENT ME!
     *
     * @param mouseStep DOCUMENT ME!
     */
    private void setMoveMouseStep(int mouseStep) {
        if (mouseStep > -1) {
            m_con.m_moveMouseStep = mouseStep;
        } else {
            String osName = getOS_Name();

            if (osName.indexOf("Windows") > -1) {
                m_con.m_moveMouseStep = MOUSE_OS_WINDOWS_SPEED;
            } else if (osName.indexOf("Linux") > -1) {
                m_con.m_moveMouseStep = MOUSE_OS_LINUX_SPEED;
            } else if (osName.indexOf("SunOS") > -1) {
                m_con.m_moveMouseStep = MOUSE_OS_SUNOS_SPEED;
            } else {
                m_con.m_moveMouseStep = mouseStep;
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    private String getOS_Name() {
        Properties prop = System.getProperties();

        return prop.getProperty("os.name");
    }

    /**
     * Get key delay.
     *
     * @return Delay value in milliseconds
     */
    public static int getKeyDelay() {
        return m_con.m_autoKeyDelay;
    }

    /**
     * Get mouse delay.
     *
     * @return Delay value in milliseconds
     */
    public static int getMoveMouseDelay() {
        return m_con.m_autoMoveMouseDelay;
    }

    /**
     * Get mouse scroll delay.
     *
     * @return delay value in milliseconds
     */
    public static int getMouseScrollDelay() {
        return m_con.m_autoMouseScrollDelay;
    }

    /**
     * Reset key mouse scroll dealy. Set all delay values 0.
     */
    public static void reset_Key_Mouse_Scroll_Delay() {
        m_con.m_autoKeyDelay = 0;
        m_con.m_autoMoveMouseDelay = 0;
        m_con.m_autoMouseScrollDelay = 0;
    }

    /**
     * Reset mouse position and set the screen middle points for the mouse position. New
     * mouse position is the screen center.
     */
    public static synchronized void resetMousePosition() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screenSize = toolkit.getScreenSize();
        m_mousePoint_X = new Double(screenSize.getWidth()).intValue() / 2;
        m_mousePoint_Y = new Double(screenSize.getHeight()).intValue() / 2;
        m_rectangle.setLocation(m_mousePoint_X, m_mousePoint_Y);
    }

    /**
     * Sets the mouse position.
     *
     * @param x x position
     * @param y y position
     */
    public static synchronized void setMousePosition(int x, int y) {
        m_mousePoint_X = x;
        m_mousePoint_Y = y;
        m_rectangle.setLocation(m_mousePoint_X, m_mousePoint_Y);
    }

    /**
     * Scrolls the mouse up or down.
     *
     * @param scrollTyp types are 'UP' and 'DOWN'.
     * @param scrollTyp number
     */
    public static synchronized void mouseScroll(String scrollTyp, int scrollNumber) {
        int typ = 0;

        if (!m_break) {
            if (scrollTyp.equalsIgnoreCase(MOUSE_SCROLL_UP)) {
                typ = -MouseEvent.MOUSE_WHEEL;
            } else if (scrollTyp.equalsIgnoreCase(MOUSE_SCROLL_DOWN)) {
                typ = MouseEvent.MOUSE_WHEEL;
            }

            if (typ != 0) {
                for (int i = 0;(i < scrollNumber) && !m_break; i++) {
                    m_con.sleep(m_autoMouseScrollDelay);
                    m_con.mouseWheel(typ);
                }
            }
        }
    }

    /**
     * Sets the mouse animate activity.
     *
     * @param animate true show the movement of the mouse cursor, otherwise place the
     *        mouse cursor to the end position without visible movement.
     */
    public static synchronized void setMouseAnimate(boolean animate) {
        m_animate = animate;
    }

    /**
     * Get mouse animate status.
     *
     * @return status is true or false
     */
    public static synchronized boolean getMouseAnimate() {
        return m_animate;
    }

    /**
     * Moves mouse pointer to given screen coordinates.
     *
     * @param points x and y cordinates.
     *
     * @return DOCUMENT ME!
     */
    public static synchronized String mouseAnimate(int[] points) {
        String res = "done";

        if (m_animate) {
            res = m_con.mouseAnimate(points[0], points[1]);
        } else {
            if (m_break) {
                res = "break";
            } else {
                m_con.mouseMove(points[0], points[1]);
                m_rectangle.setLocation(points[0], points[1]);
            }
        }

        return res;
    }

    /**
     * Generate a mouse click.
     *
     * @param clickNumber number.
     */
    public static synchronized void mouseClick(int clickNumber) {
        for (int i = 0;(i < clickNumber) && !m_break; i++) {
            m_con.mousePress(MouseEvent.BUTTON1_MASK);
            m_con.mouseRelease(MouseEvent.BUTTON1_MASK);
        }
    }

    /**
     * Generate a mouse click.
     */
    public static synchronized void mouseClick() {
        if (!m_break) {
            m_con.mousePress(MouseEvent.BUTTON1_MASK);
            m_con.mouseRelease(MouseEvent.BUTTON1_MASK);
        }
    }

    /**
     * Generate a mouse click.
     *
     * @param mousClickTyp 'RIGHT' or 'CENTER' mouse click
     */
    public static synchronized void mouseClick(String mousClickTyp) {
        m_con.mouseClick(mousClickTyp, 0);
    }

    /**
     * Generate a mouse click.
     *
     * @param mousClickTyp 'RIGHT' or 'CENTER' mouse click
     * @param mouseClickTime for mouse click in milliseconds
     */
    public static synchronized void mouseClick(String mousClickTyp, int mouseClickTime) {
        if (!m_break) {
            if (mousClickTyp.equalsIgnoreCase(MOUSE_CLICK_LEFT)) {
                m_con.mousePress(MouseEvent.BUTTON1_MASK);
                m_con.sleep(mouseClickTime);
                m_con.mouseRelease(MouseEvent.BUTTON1_MASK);
            } else if (mousClickTyp.equalsIgnoreCase(MOUSE_CLICK_CENTER)) {
                m_con.mousePress(MouseEvent.BUTTON2_MASK);
                m_con.sleep(mouseClickTime);
                m_con.mouseRelease(MouseEvent.BUTTON2_MASK);
            } else if (mousClickTyp.equalsIgnoreCase(MOUSE_CLICK_RIGHT)) {
                m_con.mousePress(MouseEvent.BUTTON3_MASK);
                m_con.sleep(mouseClickTime);
                m_con.mouseRelease(MouseEvent.BUTTON3_MASK);
            }
        }
    }

    /**
     * Move mouse to the given point and generate a click.
     *
     * @param points mouse cursor to the given  x and y.
     *
     * @return DOCUMENT ME!
     */
    public static synchronized String mouseClick(int[] points) {
        return mouseClick(points, MOUSE_CLICK_LEFT);
    }

    /**
     * Move mouse to the given point and generate a click.
     *
     * @param points mouse cursor to the given  x and y.
     * @param mousClickTyp 'RIGHT' or 'CENTER' mouse click
     *
     * @return DOCUMENT ME!
     */
    public static synchronized String mouseClick(int[] points, String mousClickTyp) {
        return mouseClick(points, mousClickTyp, 0);
    }

    /**
     * Move mouse to the given point and generate a click.
     *
     * @param points mouse cursor to the given  x and y.
     * @param mousClickTyp 'RIGHT' or 'CENTER' mouse click
     * @param mouseClickTime the mouse button and releases mouse after the given period
     *        of time.
     *
     * @return DOCUMENT ME!
     */
    public static synchronized String mouseClick(int[] points, String mousClickTyp, int mouseClickTime) {
        String res = "done";

        if (points != null) {
            res = m_con.mouseAnimate(points);

            if (res.equals("done")) {
                mouseClick(mousClickTyp, mouseClickTime);
            }
        }

        return res;
    }

    /**
     * Presses a key and releases it afterwards.
     *
     * @param key as a character
     */
    public static synchronized void key_Press_Release(char key) {
        m_con.key_Press_Release((int) key);
    }

    /**
     * Presses a key and releases it afterwards.
     *
     * @param keycode as a integer keycode (one can use the Java keycode constants as
     *        parameter)
     */
    public static synchronized void key_Press_Release(int keycode) {
        if (!m_break) {
            m_con.mousePress(MouseEvent.BUTTON1_MASK);
            m_con.mouseRelease(MouseEvent.BUTTON1_MASK);
            m_con.keyPress(keycode);
            m_con.keyRelease(keycode);
            m_con.sleep(m_autoKeyDelay);
        }
    }

    /**
     * Moves mouse pointer to the given screen coordinates with animation and generates a
     * click.
     *
     * @param x the mouse pointer to the given x and y.
     * @param y position
     */
    private synchronized void mouseClick(int x, int y) {
        int[] points = new int[] { x, y };

        if (mouseAnimate(points).equals("done")) {
            mouseClick();
        }
    }

    /**
     * Moves mouse pointer to the given screen coordinates with animation.
     *
     * @param x the mouse pointer to the given x and y.
     * @param y position
     *
     * @return DOCUMENT ME!
     */
    private synchronized String mouseAnimate(int x, int y) {
        String res = "done";
        int pointX = new Double(m_rectangle.getX()).intValue();
        int pointY = new Double(m_rectangle.getY()).intValue();

        if ((pointX == m_mousePoint_X) && (pointY == m_mousePoint_Y)) {
            mouseMove(m_mousePoint_X, m_mousePoint_Y);
        }

        if (m_mouseAnimateStyle.equalsIgnoreCase(MOUSE_ANIMATE_STYLE_BASIC)) {
            res = mouseAnimateStyle_Basic(pointX, pointY, x, y);
        } else if (m_mouseAnimateStyle.equalsIgnoreCase(MOUSE_ANIMATE_STYLE_MENU)) {
            res = mouseAnimateStyle_Menu(pointX, pointY, x, y);
        } else if (m_mouseAnimateStyle.equalsIgnoreCase(MOUSE_ANIMATE_STYLE_LINE)) {
            res = mouseAnimateStyle_Line(pointX, pointY, x, y);
        } else {
            res = mouseAnimateStyle_Basic(pointX, pointY, x, y);
        }

        m_rectangle.setLocation(x, y);

        return res;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pointX DOCUMENT ME!
     * @param pointY DOCUMENT ME!
     * @param x DOCUMENT ME!
     * @param y DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    private String mouseAnimateStyle_Basic(int pointX, int pointY, int x, int y) {
        String res = "done";

        while ((pointX != x) || (pointY != y)) {
            if (pointX < x) {
                pointX += (1 + m_moveMouseStep);

                if (pointX > x) {
                    pointX = x;
                }
            } else if (pointX > x) {
                pointX -= (1 + m_moveMouseStep);

                if (pointX < x) {
                    pointX = x;
                }
            }

            if (pointY < y) {
                pointY += (1 + m_moveMouseStep);

                if (pointY > y) {
                    pointY = y;
                }
            } else if (pointY > y) {
                pointY -= (1 + m_moveMouseStep);

                if (pointY < y) {
                    pointY = y;
                }
            }

            //Helper.log("BASIC X :" + pointX);
            //Helper.log("BASIC Y :" + pointY);
            if (m_break) {
                res = "break";

                break;
            }

            mouseMove(pointX, pointY);
            m_con.sleep(m_autoMoveMouseDelay);
        }

        return res;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pointX DOCUMENT ME!
     * @param pointY DOCUMENT ME!
     * @param x DOCUMENT ME!
     * @param y DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    private String mouseAnimateStyle_Menu(int pointX, int pointY, int x, int y) {
        String res = "done";

        while ((pointX != x) || (pointY != y)) {
            if (pointX < x) {
                pointX += (1 + m_moveMouseStep);

                if (pointX > x) {
                    pointX = x;
                }
            } else if (pointX > x) {
                pointX -= (1 + m_moveMouseStep);

                if (pointX < x) {
                    pointX = x;
                }
            } else if (pointY < y) {
                pointY += (1 + m_moveMouseStep);

                if (pointY > y) {
                    pointY = y;
                }
            } else if (pointY > y) {
                pointY -= (1 + m_moveMouseStep);

                if (pointY < y) {
                    pointY = y;
                }
            }

            //Helper.log("MENU X :" + pointX);
            //Helper.log("MENU Y :" + pointY);
            if (m_break) {
                res = "break";

                break;
            }

            mouseMove(pointX, pointY);
            m_con.sleep(m_autoMoveMouseDelay);
        }

        return res;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pointX DOCUMENT ME!
     * @param pointY DOCUMENT ME!
     * @param x DOCUMENT ME!
     * @param y DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    private String mouseAnimateStyle_Line(int pointX, int pointY, int x, int y) {
        String res = "done";

        if ((pointX != x) || (pointY != y)) {
            int[][] coordinates = getLineCoordinates(pointX, pointY, x, y);

            if (coordinates.length > 0) {
                int leng = coordinates.length;

                for (int i = 0; i < leng;) {
                    if (m_break) {
                        res = "break";

                        return res;
                    }

                    //Helper.log("X :" + coordinates[i][0]);
                    //Helper.log("Y :" + coordinates[i][1]);
                    mouseMove(coordinates[i][0], coordinates[i][1]);
                    m_con.sleep(m_autoMoveMouseDelay);
                    i += (1 + m_moveMouseStep);
                }

                mouseMove(coordinates[leng - 1][0], coordinates[leng - 1][1]);
            }
        }

        return res;
    }

    /**
     * Get the line coordinates for the specified coordinates.
     *
     * @param x1 DOCUMENT ME!
     * @param y1 DOCUMENT ME!
     * @param x2 DOCUMENT ME!
     * @param y2 DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public synchronized int[][] getLineCoordinates(int x1, int y1, int x2, int y2) {
        // Interpolate line points
        int winWidth;

        // Interpolate line points
        int winHeight;

        // Interpolate line points
        int xspot = 0;

        // Interpolate line points
        int yspot = 0;

        // Interpolate line points
        int[][] coordinates = null;
        int deltaX = Math.abs(x1 - x2);
        int deltaY = Math.abs(y1 - y2);
        int xdirection = (x2 > x1) ? 1 : (-1);
        int ydirection = (y2 > y1) ? 1 : (-1);

        if (deltaX > deltaY) {
            coordinates = new int[deltaX + 1][deltaX + 1];

            for (int dx = 0; dx <= deltaX; dx++) {
                yspot = (int) Math.floor(((double) y1 * (((double) deltaX - (double) dx) / (double) deltaX)) + ((double) y2 * ((double) dx / (double) deltaX)));
                xspot = x1 + (xdirection * dx);
                coordinates[dx][0] = xspot;
                coordinates[dx][1] = yspot;

                //Helper.log("LINE X :" + xspot);
                //Helper.log("LINE Y :" + yspot);                
            }
        } else {
            coordinates = new int[deltaY + 1][deltaY + 1];

            for (int dy = 0; dy <= deltaY; dy++) {
                xspot = (int) Math.floor(((double) x1 * (((double) deltaY - (double) dy) / (double) deltaY)) + ((double) x2 * ((double) dy / (double) deltaY)));
                yspot = y1 + (ydirection * dy);
                coordinates[dy][0] = xspot;
                coordinates[dy][1] = yspot;

                //Helper.log("LINE X :" + xspot);
                //Helper.log("LINE Y :" + yspot);
            }
        }

        return coordinates;
    }

    /**
     * Set mouse animte style. @
     *
     * @param mouseAnimateStyle position
     *
     * @return DOCUMENT ME!
     */
    public static boolean setAnimateStyle(String mouseAnimateStyle) {
        if (mouseAnimateStyle.equals("BASIC") || mouseAnimateStyle.equals("LINE") || mouseAnimateStyle.equals("MENU")) {
            m_mouseAnimateStyle = mouseAnimateStyle;

            return true;
        }

        return false;
    }

    /**
     * Break mouse animate. @
     *
     * @param b position
     */
    public static void setBreakControl(boolean b) {
        m_break = b;
    }

    /**
     * Get break status. @
     *
     * @return DOCUMENT ME!
     */
    public static boolean getBreakControl() {
        return m_break;
    }

    /**
     * Moves mouse pointer to given screen coordinates. @
     *
     * @param points position
     */
    public static void mouseMove(int[] points) {
        m_con.mouseMove(points[0], points[1]);
    }
}
