/*
 * TableModel.java
 *
 * Created on 7. M?rz 2003, 20:37
 */
package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import java.util.Vector;

import javax.swing.table.DefaultTableModel;

/**
 * Table model class. Defines a table model's properties.
 *
 * @author $author$
 * @version $Revision: 1.3 $
 */
public class TableModel extends DefaultTableModel {
    /**
     * Returns true regardless of parameter values, false only if (row,0) equals
     * typ,dialogname,path or method.
     *
     * @param row row whose value is to be queried
     * @param col column whose value is to be queried
     *
     * @return False if (row,0) equals typ,dialogname,path or method
     */
    public boolean isCellEditable(int row, int col) {
        if ((col == 0) || ((String) getValueAt(row, 0)).equals("typ") || ((String) getValueAt(row, 0)).equals("dialogName") || ((String) getValueAt(row, 0)).equals("path") || ((String) getValueAt(row, 0)).equals("method")) {
            return false;
        }

        return true;
    }

    /**
     * Returns a vector of vectors that contains the same objects as the array.
     *
     * @param data double array to be converted
     *
     * @return The new vector of vectors; if anArray is null, returns null
     */
    public Vector convert(Object[][] data) {
        return super.convertToVector(data);
    }
}
