/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: salimpsound.hxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 13:01:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _VCL_SALIMPSOUND_HXX
#define _VCL_SALIMPSOUND_HXX

#include <vsound.hxx>

#include <osl/mutex.hxx>
#include <vos/socket.hxx>

#include <tools/list.hxx>
#include <tools/link.hxx>
#include <tools/gen.hxx>
#include <tools/string.hxx>

#include <sv.h>
#include <salstype.hxx>

#include <unistd.h>
#include <sys/stat.h>

#ifdef USE_PASF
#ifdef SYSTEM_PORTAUDIO
#include <portaudio.h>
#else
#include <portaudio/portaudio.h>
#endif
#ifdef SYSTEM_SNDFILE
#include <sndfile.h>
#else
#include <sndfile/sndfile.h>
#endif
#endif

namespace vcl_sal {

// OSS can only be used on local displays

#ifdef USE_OSS
	class OSSSound : public VSound
	{
		// thread implementation
		struct OSSData
		{
			OSSSound*	m_pSound;
			long		m_nDataLen;
			long		m_nStartPos;
			long		m_nEndPos;
			long		m_nCurPos;
			int			m_nType;
		};
		DECLARE_LIST( OSSDataList, OSSData* )
		DECLARE_LIST( OSSSoundList, OSSSound* )

		static int						s_nDevice;
		static OSSDataList				s_aDataList;
		static osl::Mutex				s_aProtector;
		static OSSSoundList			s_aSounds;

		// static methods
		static BOOL 		open();
		static void 		close();
		static void 		append( OSSSound* );
		static void 		remove( OSSSound* );
		static BOOL		startSound( OSSData* pData );
		static BOOL		startAU( OSSData* pData );
		static BOOL		startRIFF( OSSData* pData );
		static int			findChunk( OSSData* pData, const char* pChunk );
		static short int	readLEShort( const char* );
		static int			readLEInt( const char* );
		static ULONG		readBELong( const char* );

		DECL_LINK( notifyStopHdl, void* );
		DECL_LINK( notifyErrorHdl, void* );
	protected:
		virtual BOOL isValid();
	public:
		OSSSound( ::X11SalSound* pSalSound );
		virtual ~OSSSound();

		virtual void play();
		virtual void stop();
		virtual void pause();
		virtual void cont();

		static void run(); // thread worker
	};
#endif

// DEVAUDIO can only be used on local displays

#ifdef USE_DEVAUDIO
	class DevAudioSound;
	struct DevAudioData
	{
		DevAudioSound*	m_pSound;
		AudioConverter*	m_pConverter;
		long			m_nDataLen;
		long			m_nStartPos;
		long			m_nEndPos;
		long			m_nCurPos;
		int				m_nType;

		DevAudioData( DevAudioSound* pSound ) :
				m_pSound( pSound ), m_pConverter( NULL ), m_nDataLen( 0 ),
				m_nStartPos( 0 ), m_nEndPos( 0 ), m_nCurPos( 0 ), m_nType( 0 )
			{}
		~DevAudioData()
			{ if( m_pConverter ) delete m_pConverter; }
	};
	DECLARE_LIST( DevAudioDataList, DevAudioData* )
	DECLARE_LIST( DevAudioSoundList, DevAudioSound* )

	class DevAudioSound : public VSound
	{
		// thread implementation

		static int						s_nDevice;
		static DevAudioDataList		s_aDataList;
		static osl::Mutex				s_aProtector;
		static DevAudioSoundList		s_aSounds;

		// static methods
		static BOOL 		open();
		static void 		close();
		static void 		append( DevAudioSound* );
		static void 		remove( DevAudioSound* );
		static BOOL			startSound( DevAudioData* pData );
		static BOOL			startAU( DevAudioData* pData );
		static BOOL			startRIFF( DevAudioData* pData );
		static int			findChunk( DevAudioData* pData, const char* pChunk );
		static short int	readLEShort( const char* );
		static int			readLEInt( const char* );
		static ULONG		readBELong( const char* );

		DECL_LINK( notifyStopHdl, void* );
		DECL_LINK( notifyErrorHdl, void* );
	protected:
		virtual BOOL isValid();
	public:
		DevAudioSound( ::X11SalSound* pSalSound );
		virtual ~DevAudioSound();

		virtual void play();
		virtual void stop();
		virtual void pause();
		virtual void cont();

		static void run();
	};
#endif


// Portaudio / libsndfile can only be used on local displays

#ifdef USE_PASF
#define PASF_BUFFER_LEN  (8192)

typedef struct
{       
    PaDeviceID       device;
    PaSampleFormat   format;
    unsigned int     bufsize;
    SNDFILE          *sndfile;
    SF_INFO          sfinfo;
    int              loop_count;
    unsigned long    start_frame;
    unsigned long    stop_frame;
    unsigned long    frame_count;
    int              done_playing;
} PASFAudioData ;


class PASFSound : public VSound
{
	private:	
    PaStream*                    m_pStream;
    PASFAudioData*               m_pData;
    
	protected:
    virtual BOOL isValid();
    
	public:
    PASFSound( ::X11SalSound* pSalSound );
    virtual ~PASFSound();
    
    virtual void play();
    virtual void stop();
    virtual void pause();
    virtual void cont();
    
};
#endif



class RPTPSound : public VSound
{
        DECLARE_LIST( RPTPSoundList, RPTPSound* )

	static BOOL								s_bConnected;
	static NAMESPACE_VOS(OConnectorSocket)		s_aConnector;
	static RPTPSoundList						s_aSounds;
	static BOOL								s_bFailedOnce;

	static BOOL			connect();
	static void			disconnect();
	static ByteString	readLine();
	static ByteString	sendCommand( const ByteString& rCommand );

	static int getFileDescriptor();
	static RPTPSound* getSoundById( ULONG );
	static ULONG      getMaxId();

	// SalYieldEntry
	static int pending( int, void* );
	static int queued( int, void* );
	static int handleEvents( int, void* );

	ULONG			m_nID;
  protected:
	virtual BOOL isValid();
  public:
  RPTPSound( ::X11SalSound* pSalSound );

	virtual	~RPTPSound();

	virtual void play();
	virtual void stop();
	virtual void pause();
	virtual void cont();
};


#ifdef USE_NAS
	class NASSound : public VSound
	{
		DECLARE_LIST( NASSoundList, NASSound* )
		
		static NASSoundList				s_aSounds;
		static void*					s_pServer;
		static BOOL						s_bFailedOnce;

		static BOOL	connect();
		static void disconnect();

		static void callback( void*, void*, void*, void* );
		// SalYieldEntry
		static int pending( int, void* );
		static int queued( int, void* );
		static int handleEvents( int, void* );

		ULONG	m_nFlowID;
	protected:
		virtual BOOL isValid();
	public:
		NASSound( ::X11SalSound* pSalSound );

		virtual	~NASSound();

		virtual void play();
		virtual void stop();
		virtual void pause();
		virtual void cont();
	};
#endif
}

#endif
