/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: drawdlg.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2006/07/25 12:42:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#define ITEMID_COLOR_TABLE      SID_COLOR_TABLE


#ifndef _SVX_SVXIDS_HRC //autogen
#include <svx/svxids.hrc>
#endif
#ifndef _MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX //autogen
#include <sfx2/bindings.hxx>
#endif
#ifndef _SVDVIEW_HXX //autogen
#include <svx/svdview.hxx>
#endif
#ifndef _SVX_TAB_AREA_HXX //autogen
#include <svx/tabarea.hxx>
#endif
#ifndef _SVX_TAB_LINE_HXX //autogen
#include <svx/tabline.hxx>
#endif
#ifndef _SVX_DRAWITEM_HXX //autogen
#include <svx/drawitem.hxx>
#endif

#include <svx/xtable.hxx>
#include "view.hxx"
#include "wrtsh.hxx"
#include "docsh.hxx"
#include "cmdid.h"

#include "drawsh.hxx"
#include <svx/svxdlg.hxx> //CHINA001
#include <svx/dialogs.hrc> //CHINA001

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


void SwDrawShell::ExecDrawDlg(SfxRequest& rReq)
{
	SwWrtShell* 	pSh 	= &GetShell();
	SdrView*		pView	= pSh->GetDrawView();
	SdrModel*		pDoc	= pView->GetModel();
	Window*			pWin    = GetView().GetWindow();
	BOOL			bChanged = pDoc->IsChanged();
	pDoc->SetChanged(FALSE);

	SfxItemSet aNewAttr( pDoc->GetItemPool() );
	pView->GetAttributes( aNewAttr );

	GetView().NoRotate();

	switch (rReq.GetSlot())
	{
		case FN_DRAWTEXT_ATTR_DLG:
		{
			SvxAbstractDialogFactory* pFact = SvxAbstractDialogFactory::Create();
			if ( pFact )
			{
				SfxAbstractTabDialog *pDlg = pFact->CreateTextTabDialog( NULL, &aNewAttr, ResId( RID_SVXDLG_TEXT ), pView );
				USHORT nResult = pDlg->Execute();

				if (nResult == RET_OK)
				{
	                if (pView->AreObjectsMarked())
	                {
	                    pSh->StartAction();
	                    pView->SetAttributes(*pDlg->GetOutputItemSet());
	                    rReq.Done(*(pDlg->GetOutputItemSet()));
	                    pSh->EndAction();
	                }
	            }

				delete( pDlg );
			}
		}
		break;

		case SID_ATTRIBUTES_AREA:
		{
			BOOL bHasMarked = pView->AreObjectsMarked();


			//CHINA001 SvxAreaTabDialog* pDlg = new SvxAreaTabDialog( NULL, &aNewAttr, pDoc, pView );
			SvxAbstractDialogFactory* pFact = SvxAbstractDialogFactory::Create();
			DBG_ASSERT(pFact, "Dialogdiet Factory fail!");//CHINA001
			AbstractSvxAreaTabDialog * pDlg = pFact->CreateSvxAreaTabDialog( NULL,
																			&aNewAttr, 
																			pDoc,
																			ResId(RID_SVXDLG_AREA),
																			pView);
			DBG_ASSERT(pDlg, "Dialogdiet fail!");//CHINA001
			const SvxColorTableItem* pColorItem = (const SvxColorTableItem*)
									GetView().GetDocShell()->GetItem(SID_COLOR_TABLE);
			if(pColorItem->GetColorTable() == XColorTable::GetStdColorTable())
				pDlg->DontDeleteColorTable();
			if (pDlg->Execute() == RET_OK)
			{
                pSh->StartAction();
                if (bHasMarked)
					pView->SetAttributes(*pDlg->GetOutputItemSet());
				else
					pView->SetDefaultAttr(*pDlg->GetOutputItemSet(), FALSE);
                pSh->EndAction();

				static USHORT __READONLY_DATA aInval[] =
				{
					SID_ATTR_FILL_STYLE, SID_ATTR_FILL_COLOR, 0
				};
				SfxBindings &rBnd = GetView().GetViewFrame()->GetBindings();
				rBnd.Invalidate(aInval);
				rBnd.Update(SID_ATTR_FILL_STYLE);
				rBnd.Update(SID_ATTR_FILL_COLOR);
			}
			delete pDlg;
		}
		break;

		case SID_ATTRIBUTES_LINE:
		{
			BOOL bHasMarked = pView->AreObjectsMarked();

			const SdrObject* pObj = NULL;
			const SdrMarkList& rMarkList = pView->GetMarkedObjectList();
			if( rMarkList.GetMarkCount() == 1 )
				pObj = rMarkList.GetMark(0)->GetMarkedSdrObj();

			//CHINA001 SvxLineTabDialog* pDlg = new SvxLineTabDialog(NULL, &aNewAttr,
//CHINA001 															pDoc, pObj, bHasMarked);
			SvxAbstractDialogFactory* pFact = SvxAbstractDialogFactory::Create();
			DBG_ASSERT(pFact, "Dialogdiet Factory fail!");//CHINA001
			SfxAbstractTabDialog * pDlg = pFact->CreateSvxLineTabDialog( NULL,
					&aNewAttr, 
				pDoc,
				ResId(RID_SVXDLG_LINE),
				pObj,
				bHasMarked);
			DBG_ASSERT(pDlg, "Dialogdiet fail!");//CHINA001
			if (pDlg->Execute() == RET_OK)
			{
                pSh->StartAction();
                if(bHasMarked)
					pView->SetAttrToMarked(*pDlg->GetOutputItemSet(), FALSE);
				else
					pView->SetDefaultAttr(*pDlg->GetOutputItemSet(), FALSE);
                pSh->EndAction();

				static USHORT __READONLY_DATA aInval[] =
				{
					SID_ATTR_LINE_STYLE, SID_ATTR_LINE_WIDTH,
					SID_ATTR_LINE_COLOR, 0
				};

				GetView().GetViewFrame()->GetBindings().Invalidate(aInval);
			}
			delete pDlg;
		}
		break;

		default:
			break;
	}


	if (pDoc->IsChanged())
		GetShell().SetModified();
	else
		if (bChanged)
			pDoc->SetChanged(TRUE);
}

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


void SwDrawShell::ExecDrawAttrArgs(SfxRequest& rReq)
{
	SwWrtShell* pSh   = &GetShell();
	SdrView*	pView = pSh->GetDrawView();
	const SfxItemSet* pArgs = rReq.GetArgs();
	BOOL 		bChanged = pView->GetModel()->IsChanged();
	pView->GetModel()->SetChanged(FALSE);

	GetView().NoRotate();

	if (pArgs)
	{
		if(pView->AreObjectsMarked())
			pView->SetAttrToMarked(*rReq.GetArgs(), FALSE);
		else
			pView->SetDefaultAttr(*rReq.GetArgs(), FALSE);
	}
	else
	{
		SfxDispatcher* pDis = pSh->GetView().GetViewFrame()->GetDispatcher();
		switch (rReq.GetSlot())
		{
			case SID_ATTR_FILL_STYLE:
			case SID_ATTR_FILL_COLOR:
			case SID_ATTR_FILL_GRADIENT:
			case SID_ATTR_FILL_HATCH:
			case SID_ATTR_FILL_BITMAP:
				pDis->Execute(SID_ATTRIBUTES_AREA, FALSE);
				break;
			case SID_ATTR_LINE_STYLE:
			case SID_ATTR_LINE_DASH:
			case SID_ATTR_LINE_WIDTH:
			case SID_ATTR_LINE_COLOR:
				pDis->Execute(SID_ATTRIBUTES_LINE, FALSE);
				break;
		}
	}
	if (pView->GetModel()->IsChanged())
		GetShell().SetModified();
	else
		if (bChanged)
			pView->GetModel()->SetChanged(TRUE);
}

/*--------------------------------------------------------------------
	Beschreibung:
 --------------------------------------------------------------------*/


void SwDrawShell::GetDrawAttrState(SfxItemSet& rSet)
{
	SdrView* pSdrView = GetShell().GetDrawView();

	if (pSdrView->AreObjectsMarked())
	{
		BOOL bDisable = Disable( rSet );

		if( !bDisable )
			pSdrView->GetAttributes( rSet );
	}
	else
		rSet.Put(pSdrView->GetDefaultAttr());
}



