/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svdopath.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 18:50:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVDOPATH_HXX
#define _SVDOPATH_HXX

#ifndef _SVDOTEXT_HXX
#include "svdotext.hxx"
#endif

#ifndef _XPOLY_HXX
#include "xpoly.hxx"
#endif

#ifndef INCLUDED_SVXDLLAPI_H
#include "svx/svxdllapi.h"
#endif

//************************************************************
//   Vorausdeklarationen
//************************************************************

class XPolyPolygon;

//************************************************************
//   Defines
//************************************************************

enum SdrPathType {SDRPATH_NONE,SDRPATH_LINE,SDRPATH_CURVE};

//************************************************************
//   Hilfsklasse SdrPathObjGeoData
//
// fuer Undo/Redo
//
//************************************************************

class SdrPathObjGeoData : public SdrTextObjGeoData
{
	friend class				SdrPolyEditView;

public:
	XPolyPolygon				aPathPolygon;
	SdrObjKind					eKind;

	SdrPathObjGeoData();
	virtual ~SdrPathObjGeoData();
};

//************************************************************
//   SdrPathObj
//************************************************************

class SVX_DLLPUBLIC SdrPathObj : public SdrTextObj
{
	friend class				ImpSdrPathDragData;
	friend class				SdrPolyEditView;

protected:
	XPolyPolygon				aPathPolygon;
	SdrObjKind					eKind;

	// Hilfsvariable fuer Create
	USHORT						bCreating; // nActPoly;

protected:
	// Hilfsfunktion fuer GET/SET/INS/etc. PNT
	FASTBOOL FindPolyPnt(USHORT nAbsPnt, USHORT& rPolyNum, USHORT& rPointNum, FASTBOOL bAllPoints=TRUE) const;
	void ImpSetClosed(FASTBOOL bClose);
	void ImpForceKind();
	void ImpForceLineWink();
	void ImpConvertSegment(USHORT nPolyNum, USHORT nPointNum, SdrPathType ePathType, FASTBOOL bIgnoreSmooth);
	void ImpSetSmoothFlag(USHORT nPolyNum, USHORT nPointNum, XPolyFlags eFlag);

public:
	virtual void SetRectsDirty(sal_Bool bNotMyself = sal_False);

public:
	TYPEINFO();
	SdrPathObj(SdrObjKind eNewKind);
	SdrPathObj(SdrObjKind eNewKind, const XPolyPolygon& rPathPoly);
	SdrPathObj(const Point& rPt1, const Point& rPt2);
	virtual ~SdrPathObj();

	virtual void TakeObjInfo(SdrObjTransformInfoRec& rInfo) const;
	virtual UINT16 GetObjIdentifier() const;
	virtual void RecalcBoundRect();
	virtual void TakeUnrotatedSnapRect(Rectangle& rRect) const;
	virtual sal_Bool DoPaintObject(XOutputDevice& rOut, const SdrPaintInfoRec& rInfoRec) const;
	virtual SdrObject* CheckHit(const Point& rPnt, USHORT nTol, const SetOfByte* pVisiLayer) const;
	virtual void operator=(const SdrObject& rObj);

	virtual void TakeObjNameSingul(String& rName) const;
	virtual void TakeObjNamePlural(String& rName) const;
	virtual void TakeXorPoly(XPolyPolygon& rXPolyPoly, FASTBOOL bDetail) const;
	//#110094#-12	
	//virtual void TakeContour(XPolyPolygon& rXPoly, SdrContourType eType) const;
	virtual void RecalcSnapRect();
	virtual void NbcSetSnapRect(const Rectangle& rRect);
	virtual void TakeContour(XPolyPolygon& rPoly) const;
	virtual USHORT GetHdlCount() const;
	virtual SdrHdl* GetHdl(USHORT nHdlNum) const;
	virtual USHORT GetPlusHdlCount(const SdrHdl& rHdl) const;
	virtual SdrHdl* GetPlusHdl(const SdrHdl& rHdl, USHORT nPlNum) const;
	virtual void AddToHdlList(SdrHdlList& rHdlList) const;

	virtual FASTBOOL HasSpecialDrag() const;
	virtual FASTBOOL BegDrag(SdrDragStat& rDrag) const;
	virtual FASTBOOL MovDrag(SdrDragStat& rDrag) const;
	virtual FASTBOOL EndDrag(SdrDragStat& rDrag);
	virtual void BrkDrag(SdrDragStat& rDrag) const;

	virtual String GetDragComment(const SdrDragStat& rDrag, FASTBOOL bUndoDragComment, FASTBOOL bCreateComment) const;

	virtual void TakeDragPoly(const SdrDragStat& rDrag, XPolyPolygon& rXPP) const;

	virtual FASTBOOL BegCreate(SdrDragStat& rStat);
	virtual FASTBOOL MovCreate(SdrDragStat& rStat);
	virtual FASTBOOL EndCreate(SdrDragStat& rStat, SdrCreateCmd eCmd);
	virtual FASTBOOL BckCreate(SdrDragStat& rStat);
	virtual void BrkCreate(SdrDragStat& rStat);
	virtual void TakeCreatePoly(const SdrDragStat& rDrag, XPolyPolygon& rXPP) const;
	Pointer GetCreatePointer() const;

	virtual void NbcMove(const Size& aSize);
	virtual void NbcResize(const Point& rRefPnt, const Fraction& aXFact, const Fraction& aYFact);
	virtual void NbcRotate(const Point& rRefPnt, long nAngle, double fSin, double fCos);
	virtual void NbcMirror(const Point& rRefPnt1, const Point& rRefPnt2);
	virtual void NbcShear(const Point& rRefPnt, long nAngle, double fTan, FASTBOOL bVShear);

	virtual USHORT GetSnapPointCount() const;
	virtual Point GetSnapPoint(USHORT i) const;

	virtual FASTBOOL IsPolyObj() const;
	virtual USHORT GetPointCount() const;
	virtual const Point& GetPoint(USHORT nHdlNum) const;
	virtual void NbcSetPoint(const Point& rPnt, USHORT nHdlNum);

	// Punkt einfuegen
	virtual USHORT NbcInsPoint(const Point& rPos, FASTBOOL bNewObj, FASTBOOL bHideHim, FASTBOOL& rInsNextAfter);
	virtual USHORT NbcInsPoint(USHORT i, const Point& rPos, FASTBOOL bInsAfter, FASTBOOL bNewObj, FASTBOOL bHideHim);

	// Punkt loeschen
	virtual FASTBOOL NbcDelPoint(USHORT nHdlNum);

	// An diesem Punkt auftrennen
	virtual SdrObject* NbcRipPoint(USHORT nHdlNum, USHORT& rNewPt0Index);

	// Objekt schliessen
	virtual void NbcShut();

protected:
	virtual SdrObjGeoData* NewGeoData() const;
	virtual void SaveGeoData(SdrObjGeoData& rGeo) const;
	virtual void RestGeoData(const SdrObjGeoData& rGeo);

public:
	virtual SdrObject* DoConvertToPolyObj(BOOL bBezier) const;

	//BFS01virtual void WriteData(SvStream& rOut) const;
	//BFS01virtual void ReadData(const SdrObjIOHeader& rHead, SvStream& rIn);

	// Bezierpolygon holen/setzen
	const XPolyPolygon& GetPathPoly() const { return aPathPolygon; }
	void SetPathPoly(const XPolyPolygon& rPathPoly);
	void NbcSetPathPoly(const XPolyPolygon& rPathPoly);

	// Man stecke die Handlenummer rein und bekomme die Polygon- und Punktnummer
	// des zugehoerigen Punkts im XPolyPolygon.
	FASTBOOL TakePolyIdxForHdlNum(USHORT nHdlNum, USHORT& rPolyNum, USHORT& rPointNum) const { return FindPolyPnt(nHdlNum,rPolyNum,rPointNum,FALSE); }

	// Spezialfunktionen fuer Bezierpolygon-Bearbeitung
	static FASTBOOL IsClosed(SdrObjKind eKind) { return eKind==OBJ_POLY || eKind==OBJ_PATHPOLY || eKind==OBJ_PATHFILL || eKind==OBJ_FREEFILL || eKind==OBJ_SPLNFILL; }
	static FASTBOOL IsLine(SdrObjKind eKind) { return eKind==OBJ_PLIN || eKind==OBJ_PATHPLIN || eKind==OBJ_PATHLINE || eKind==OBJ_FREELINE || eKind==OBJ_SPLNLINE || eKind==OBJ_LINE; }
	static FASTBOOL IsFreeHand(SdrObjKind eKind) { return eKind==OBJ_FREELINE || eKind==OBJ_FREEFILL; }
	static FASTBOOL IsBezier(SdrObjKind eKind) { return eKind==OBJ_PATHLINE || eKind==OBJ_PATHFILL; }
	static FASTBOOL IsSpline(SdrObjKind eKind) { return eKind==OBJ_SPLNLINE || eKind==OBJ_SPLNFILL; }
	FASTBOOL IsClosed() const { return eKind==OBJ_POLY || eKind==OBJ_PATHPOLY || eKind==OBJ_PATHFILL || eKind==OBJ_FREEFILL || eKind==OBJ_SPLNFILL; }
	FASTBOOL IsLine() const { return eKind==OBJ_PLIN || eKind==OBJ_PATHPLIN || eKind==OBJ_PATHLINE || eKind==OBJ_FREELINE || eKind==OBJ_SPLNLINE || eKind==OBJ_LINE; }
	FASTBOOL IsFreeHand() const { return eKind==OBJ_FREELINE || eKind==OBJ_FREEFILL; }
	FASTBOOL IsBezier() const { return eKind==OBJ_PATHLINE || eKind==OBJ_PATHFILL; }
	FASTBOOL IsSpline() const { return eKind==OBJ_SPLNLINE || eKind==OBJ_SPLNFILL; }

	// Pfad schliessen bzw. oeffnen; im letzteren Fall den Endpunkt um
	// "nOpenDistance" verschieben
	void ToggleClosed(long nOpenDistance);

	// Pfadabschnitt in Kurve bzw. Linie umwandeln. Toggle!
	void ConvertSegment(const SdrHdl* pHdl);

	// Flag fuer Uebergang zwischen zwei Pfadsegmenten setzen
	void SetSmoothFlag(const SdrHdl* pHdl, XPolyFlags eFlag);
	void NbcSetSmoothFlag(const SdrHdl* pHdl, XPolyFlags eFlag);
	XPolyFlags GetSmoothFlag(const SdrHdl* pHdl) const;

	// Welche Umwandlung eines Pfadabschnitts ist moeglich?
	SdrPathType CanConvertSegment(const SdrHdl* pHdl) const;

	// Feststellen von welcher Art das Segment ist
	SdrPathType GetSegmentType(const SdrHdl* pHdl) const;

	// eType=SDRPATH_NONE bedeutet Toggle
	void ConvertSegment(const SdrHdl* pHdl, SdrPathType eType, FASTBOOL bIgnoreSmooth=FALSE);
	void NbcConvertSegment(const SdrHdl* pHdl, SdrPathType eType, FASTBOOL bIgnoreSmooth=FALSE);

	// Alle Segmente konvertieren, eType=SDRPATH_NONE bedeutet Toggle
	void ConvertAllSegments(SdrPathType ePathType);

	////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	// transformation interface for StarOfficeAPI. This implements support for 
	// homogen 3x3 matrices containing the transformation of the SdrObject. At the
	// moment it contains a shearX, rotation and translation, but for setting all linear 
	// transforms like Scale, ShearX, ShearY, Rotate and Translate are supported.
	//
	////////////////////////////////////////////////////////////////////////////////////////////////////
	// gets base transformation and rectangle of object. If it's an SdrPathObj it fills the PolyPolygon
	// with the base geometry and returns TRUE. Otherwise it returns FALSE.
	virtual BOOL TRGetBaseGeometry(Matrix3D& rMat, XPolyPolygon& rPolyPolygon) const;
	// sets the base geometry of the object using infos contained in the homogen 3x3 matrix. 
	// If it's an SdrPathObj it will use the provided geometry information. The Polygon has 
	// to use (0,0) as upper left and will be scaled to the given size in the matrix.
	virtual void TRSetBaseGeometry(const Matrix3D& rMat, const XPolyPolygon& rPolyPolygon);
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#endif //_SVDOPATH_HXX

