/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: component.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2006/06/20 00:07:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "ExternalUriReferenceTranslator.hxx"
#include "UriReferenceFactory.hxx"
#include "UriSchemeParser_vndDOTsunDOTstarDOTscript.hxx"
#include "VndSunStarPkgUrlReferenceFactory.hxx"

#include "cppuhelper/factory.hxx"
#include "cppuhelper/implementationentry.hxx"
#include "sal/types.h"
#include "uno/environment.h"
#include "uno/lbnames.h"

namespace {

cppu::ImplementationEntry entries[] = {
    { stoc::uriproc::ExternalUriReferenceTranslator::create,
      stoc::uriproc::ExternalUriReferenceTranslator::getImplementationName,
      stoc::uriproc::ExternalUriReferenceTranslator::getSupportedServiceNames,
      cppu::createSingleComponentFactory, 0, 0 },
    { stoc::uriproc::UriReferenceFactory::create,
      stoc::uriproc::UriReferenceFactory::getImplementationName,
      stoc::uriproc::UriReferenceFactory::getSupportedServiceNames,
      cppu::createSingleComponentFactory, 0, 0 },
    { stoc::uriproc::UriSchemeParser_vndDOTsunDOTstarDOTscript::create,
      stoc::uriproc::UriSchemeParser_vndDOTsunDOTstarDOTscript::
          getImplementationName,
      stoc::uriproc::UriSchemeParser_vndDOTsunDOTstarDOTscript::
          getSupportedServiceNames,
      cppu::createSingleComponentFactory, 0, 0 },
    { stoc::uriproc::VndSunStarPkgUrlReferenceFactory::create,
      stoc::uriproc::VndSunStarPkgUrlReferenceFactory::getImplementationName,
      stoc::uriproc::VndSunStarPkgUrlReferenceFactory::getSupportedServiceNames,
      cppu::createSingleComponentFactory, 0, 0 },
    { 0, 0, 0, 0, 0, 0 } };

}

extern "C" sal_Bool SAL_CALL component_writeInfo(
    void * serviceManager, void * registryKey)
{
    return cppu::component_writeInfoHelper(
        serviceManager, registryKey, entries);
}

extern "C" void * SAL_CALL component_getFactory(
    char const * implName, void * serviceManager, void * registryKey)
{
    return cppu::component_getFactoryHelper(
        implName, serviceManager, registryKey, entries);
}

extern "C" void SAL_CALL component_getImplementationEnvironment(
    char const ** envTypeName, uno_Environment **)
{
    *envTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}
