/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: appchild.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2006/05/02 16:14:56 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef GCC
#pragma hdrstop
#endif

#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif

#include "app.hxx"
#include "appdata.hxx"
#include "workwin.hxx"
#include "childwin.hxx"
#include "arrdecl.hxx"
#include "templdlg.hxx"
#include "request.hxx"
#include "bindings.hxx"
#include "dispatch.hxx"
#include "sfxtypes.hxx"
#include "module.hxx"
#include "sfxsids.hrc"

//=========================================================================


void SfxApplication::RegisterChildWindow_Impl( SfxModule *pMod, SfxChildWinFactory *pFact )
{
	if ( pMod )
	{
		pMod->RegisterChildWindow( pFact );
		return;
	}

	if (!pAppData_Impl->pFactArr)
		pAppData_Impl->pFactArr = new SfxChildWinFactArr_Impl;

//#ifdef DBG_UTIL
	for (USHORT nFactory=0; nFactory<pAppData_Impl->pFactArr->Count(); ++nFactory)
	{
		if (pFact->nId ==  (*pAppData_Impl->pFactArr)[nFactory]->nId)
		{
			pAppData_Impl->pFactArr->Remove( nFactory );
//			DBG_ERROR("ChildWindow mehrfach registriert!");
//			return;
		}
	}
//#endif

	pAppData_Impl->pFactArr->C40_INSERT(
		SfxChildWinFactory, pFact, pAppData_Impl->pFactArr->Count() );
}

void SfxApplication::RegisterChildWindowContext_Impl( SfxModule *pMod, USHORT nId,
		SfxChildWinContextFactory *pFact)
{
	SfxChildWinFactArr_Impl *pFactories;
	SfxChildWinFactory *pF = NULL;
	if ( pMod )
	{
		// Modul "ubergeben, ChildwindowFactory dort suchen
		pFactories = pMod->GetChildWinFactories_Impl();
		if ( pFactories )
		{
			USHORT nCount = pFactories->Count();
			for (USHORT nFactory=0; nFactory<nCount; ++nFactory)
			{
				SfxChildWinFactory *pFac = (*pFactories)[nFactory];
				if ( nId == pFac->nId )
				{
					// Factory gefunden, Context dort registrieren
					pF = pFac;
					break;
				}
			}
		}
	}

	if ( !pF )
	{
		// Factory an der Application suchen
		DBG_ASSERT( pAppData_Impl, "Keine AppDaten!" );
		DBG_ASSERT( pAppData_Impl->pFactArr, "Keine Factories!" );

		pFactories = pAppData_Impl->pFactArr;
		USHORT nCount = pFactories->Count();
		for (USHORT nFactory=0; nFactory<nCount; ++nFactory)
		{
			SfxChildWinFactory *pFac = (*pFactories)[nFactory];
			if ( nId == pFac->nId )
			{
				if ( pMod )
				{
					// Wenn der Context von einem Modul registriert wurde,
					// mu\s die ChildwindowFactory auch dort zur Verf"ugung
					// stehen, sonst m"u\ste sich die Contextfactory im DLL-Exit
					// wieder abmelden !
					pF = new SfxChildWinFactory( pFac->pCtor, pFac->nId,
							pFac->nPos );
					pMod->RegisterChildWindow( pF );
				}
				else
					pF = pFac;
				break;
			}
		}
	}

	if ( pF )
	{
		if ( !pF->pArr )
			pF->pArr = new SfxChildWinContextArr_Impl;
		pF->pArr->C40_INSERT( SfxChildWinContextFactory, pFact, pF->pArr->Count() );
		return;
	}

	DBG_ERROR( "Kein ChildWindow fuer diesen Context!" );
}

//--------------------------------------------------------------------

SfxChildWinFactArr_Impl& SfxApplication::GetChildWinFactories_Impl() const
{
	return ( *(pAppData_Impl->pFactArr));
}

//--------------------------------------------------------------------

SfxTemplateDialog* SfxApplication::GetTemplateDialog()
{
    if ( pAppData_Impl->pViewFrame )
    {
        SfxChildWindow *pChild = pAppData_Impl->pViewFrame->GetChildWindow(SfxTemplateDialogWrapper::GetChildWindowId());
        return pChild ? (SfxTemplateDialog*) pChild->GetWindow() : 0;
    }

    return NULL;
}

//--------------------------------------------------------------------

SfxWorkWindow* SfxApplication::GetWorkWindow_Impl(const SfxViewFrame *pFrame) const
{
    if ( pFrame )
        return pFrame->GetFrame()->GetWorkWindow_Impl();
    else if ( pAppData_Impl->pViewFrame )
        return pAppData_Impl->pViewFrame->GetFrame()->GetWorkWindow_Impl();
    else
        return NULL;
}

